/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.TerminalAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateTerminalActionRequest {
    private final String idempotencyKey;
    private final TerminalAction action;
    private final Map<String, Object> additionalProperties;

    private CreateTerminalActionRequest(String idempotencyKey, TerminalAction action, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.action = action;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="action")
    public TerminalAction getAction() {
        return this.action;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateTerminalActionRequest && this.equalTo((CreateTerminalActionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateTerminalActionRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.action.equals(other.action);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.action);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    ActionStage,
    _FinalStage {
        private String idempotencyKey;
        private TerminalAction action;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateTerminalActionRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.action(other.getAction());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public ActionStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="action")
        public _FinalStage action(@NotNull TerminalAction action) {
            this.action = Objects.requireNonNull(action, "action must not be null");
            return this;
        }

        @Override
        public CreateTerminalActionRequest build() {
            return new CreateTerminalActionRequest(this.idempotencyKey, this.action, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateTerminalActionRequest build();
    }

    public static interface ActionStage {
        public _FinalStage action(@NotNull TerminalAction var1);
    }

    public static interface IdempotencyKeyStage {
        public ActionStage idempotencyKey(@NotNull String var1);

        public Builder from(CreateTerminalActionRequest var1);
    }
}

