/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.terminal.AsyncRawRefundsClient;
import com.squareup.square.terminal.types.CancelRefundsRequest;
import com.squareup.square.terminal.types.CreateTerminalRefundRequest;
import com.squareup.square.terminal.types.GetRefundsRequest;
import com.squareup.square.terminal.types.SearchTerminalRefundsRequest;
import com.squareup.square.types.CancelTerminalRefundResponse;
import com.squareup.square.types.CreateTerminalRefundResponse;
import com.squareup.square.types.GetTerminalRefundResponse;
import com.squareup.square.types.SearchTerminalRefundsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncRefundsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawRefundsClient rawClient;

    public AsyncRefundsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawRefundsClient(clientOptions);
    }

    public AsyncRawRefundsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateTerminalRefundResponse> create(CreateTerminalRefundRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateTerminalRefundResponse)response.body());
    }

    public CompletableFuture<CreateTerminalRefundResponse> create(CreateTerminalRefundRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateTerminalRefundResponse)response.body());
    }

    public CompletableFuture<SearchTerminalRefundsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchTerminalRefundsResponse)response.body());
    }

    public CompletableFuture<SearchTerminalRefundsResponse> search(SearchTerminalRefundsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchTerminalRefundsResponse)response.body());
    }

    public CompletableFuture<SearchTerminalRefundsResponse> search(SearchTerminalRefundsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchTerminalRefundsResponse)response.body());
    }

    public CompletableFuture<GetTerminalRefundResponse> get(GetRefundsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetTerminalRefundResponse)response.body());
    }

    public CompletableFuture<GetTerminalRefundResponse> get(GetRefundsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetTerminalRefundResponse)response.body());
    }

    public CompletableFuture<CancelTerminalRefundResponse> cancel(CancelRefundsRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelTerminalRefundResponse)response.body());
    }

    public CompletableFuture<CancelTerminalRefundResponse> cancel(CancelRefundsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelTerminalRefundResponse)response.body());
    }
}

