/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.terminal.AsyncRawCheckoutsClient;
import com.squareup.square.terminal.types.CancelCheckoutsRequest;
import com.squareup.square.terminal.types.CreateTerminalCheckoutRequest;
import com.squareup.square.terminal.types.GetCheckoutsRequest;
import com.squareup.square.terminal.types.SearchTerminalCheckoutsRequest;
import com.squareup.square.types.CancelTerminalCheckoutResponse;
import com.squareup.square.types.CreateTerminalCheckoutResponse;
import com.squareup.square.types.GetTerminalCheckoutResponse;
import com.squareup.square.types.SearchTerminalCheckoutsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCheckoutsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCheckoutsClient rawClient;

    public AsyncCheckoutsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCheckoutsClient(clientOptions);
    }

    public AsyncRawCheckoutsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateTerminalCheckoutResponse> create(CreateTerminalCheckoutRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<CreateTerminalCheckoutResponse> create(CreateTerminalCheckoutRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<SearchTerminalCheckoutsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchTerminalCheckoutsResponse)response.body());
    }

    public CompletableFuture<SearchTerminalCheckoutsResponse> search(SearchTerminalCheckoutsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchTerminalCheckoutsResponse)response.body());
    }

    public CompletableFuture<SearchTerminalCheckoutsResponse> search(SearchTerminalCheckoutsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchTerminalCheckoutsResponse)response.body());
    }

    public CompletableFuture<GetTerminalCheckoutResponse> get(GetCheckoutsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<GetTerminalCheckoutResponse> get(GetCheckoutsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<CancelTerminalCheckoutResponse> cancel(CancelCheckoutsRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelTerminalCheckoutResponse)response.body());
    }

    public CompletableFuture<CancelTerminalCheckoutResponse> cancel(CancelCheckoutsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelTerminalCheckoutResponse)response.body());
    }
}

