/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.terminal;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.terminal.AsyncRawActionsClient;
import com.squareup.square.terminal.types.CancelActionsRequest;
import com.squareup.square.terminal.types.CreateTerminalActionRequest;
import com.squareup.square.terminal.types.GetActionsRequest;
import com.squareup.square.terminal.types.SearchTerminalActionsRequest;
import com.squareup.square.types.CancelTerminalActionResponse;
import com.squareup.square.types.CreateTerminalActionResponse;
import com.squareup.square.types.GetTerminalActionResponse;
import com.squareup.square.types.SearchTerminalActionsResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncActionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawActionsClient rawClient;

    public AsyncActionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawActionsClient(clientOptions);
    }

    public AsyncRawActionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateTerminalActionResponse> create(CreateTerminalActionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateTerminalActionResponse)response.body());
    }

    public CompletableFuture<CreateTerminalActionResponse> create(CreateTerminalActionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateTerminalActionResponse)response.body());
    }

    public CompletableFuture<SearchTerminalActionsResponse> search() {
        return this.rawClient.search().thenApply(response -> (SearchTerminalActionsResponse)response.body());
    }

    public CompletableFuture<SearchTerminalActionsResponse> search(SearchTerminalActionsRequest request) {
        return this.rawClient.search(request).thenApply(response -> (SearchTerminalActionsResponse)response.body());
    }

    public CompletableFuture<SearchTerminalActionsResponse> search(SearchTerminalActionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).thenApply(response -> (SearchTerminalActionsResponse)response.body());
    }

    public CompletableFuture<GetTerminalActionResponse> get(GetActionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetTerminalActionResponse)response.body());
    }

    public CompletableFuture<GetTerminalActionResponse> get(GetActionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetTerminalActionResponse)response.body());
    }

    public CompletableFuture<CancelTerminalActionResponse> cancel(CancelActionsRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelTerminalActionResponse)response.body());
    }

    public CompletableFuture<CancelTerminalActionResponse> cancel(CancelActionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelTerminalActionResponse)response.body());
    }
}

