/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.Nullable;
import com.squareup.square.core.NullableNonemptyFilter;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.VisibilityFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCustomAttributeDefinitionsRequest {
    private final Optional<VisibilityFilter> visibilityFilter;
    private final Optional<String> cursor;
    private final Optional<Integer> limit;
    private final Map<String, Object> additionalProperties;

    private ListCustomAttributeDefinitionsRequest(Optional<VisibilityFilter> visibilityFilter, Optional<String> cursor, Optional<Integer> limit, Map<String, Object> additionalProperties) {
        this.visibilityFilter = visibilityFilter;
        this.cursor = cursor;
        this.limit = limit;
        this.additionalProperties = additionalProperties;
    }

    @JsonIgnore
    public Optional<VisibilityFilter> getVisibilityFilter() {
        if (this.visibilityFilter == null) {
            return Optional.empty();
        }
        return this.visibilityFilter;
    }

    @JsonIgnore
    public Optional<String> getCursor() {
        if (this.cursor == null) {
            return Optional.empty();
        }
        return this.cursor;
    }

    @JsonIgnore
    public Optional<Integer> getLimit() {
        if (this.limit == null) {
            return Optional.empty();
        }
        return this.limit;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="visibility_filter")
    private Optional<VisibilityFilter> _getVisibilityFilter() {
        return this.visibilityFilter;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="cursor")
    private Optional<String> _getCursor() {
        return this.cursor;
    }

    @JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=NullableNonemptyFilter.class)
    @JsonProperty(value="limit")
    private Optional<Integer> _getLimit() {
        return this.limit;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCustomAttributeDefinitionsRequest && this.equalTo((ListCustomAttributeDefinitionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCustomAttributeDefinitionsRequest other) {
        return this.visibilityFilter.equals(other.visibilityFilter) && this.cursor.equals(other.cursor) && this.limit.equals(other.limit);
    }

    public int hashCode() {
        return Objects.hash(this.visibilityFilter, this.cursor, this.limit);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<VisibilityFilter> visibilityFilter = Optional.empty();
        private Optional<String> cursor = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCustomAttributeDefinitionsRequest other) {
            this.visibilityFilter(other.getVisibilityFilter());
            this.cursor(other.getCursor());
            this.limit(other.getLimit());
            return this;
        }

        @JsonSetter(value="visibility_filter", nulls=Nulls.SKIP)
        public Builder visibilityFilter(Optional<VisibilityFilter> visibilityFilter) {
            this.visibilityFilter = visibilityFilter;
            return this;
        }

        public Builder visibilityFilter(VisibilityFilter visibilityFilter) {
            this.visibilityFilter = Optional.ofNullable(visibilityFilter);
            return this;
        }

        public Builder visibilityFilter(Nullable<VisibilityFilter> visibilityFilter) {
            this.visibilityFilter = visibilityFilter.isNull() ? null : (visibilityFilter.isEmpty() ? Optional.empty() : Optional.of(visibilityFilter.get()));
            return this;
        }

        @JsonSetter(value="cursor", nulls=Nulls.SKIP)
        public Builder cursor(Optional<String> cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder cursor(String cursor) {
            this.cursor = Optional.ofNullable(cursor);
            return this;
        }

        public Builder cursor(Nullable<String> cursor) {
            this.cursor = cursor.isNull() ? null : (cursor.isEmpty() ? Optional.empty() : Optional.of(cursor.get()));
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        public Builder limit(Nullable<Integer> limit) {
            this.limit = limit.isNull() ? null : (limit.isEmpty() ? Optional.empty() : Optional.of(limit.get()));
            return this;
        }

        public ListCustomAttributeDefinitionsRequest build() {
            return new ListCustomAttributeDefinitionsRequest(this.visibilityFilter, this.cursor, this.limit, this.additionalProperties);
        }
    }
}

