/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteCustomAttributesRequest {
    private final String orderId;
    private final String customAttributeKey;
    private final Map<String, Object> additionalProperties;

    private DeleteCustomAttributesRequest(String orderId, String customAttributeKey, Map<String, Object> additionalProperties) {
        this.orderId = orderId;
        this.customAttributeKey = customAttributeKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="order_id")
    public String getOrderId() {
        return this.orderId;
    }

    @JsonProperty(value="custom_attribute_key")
    public String getCustomAttributeKey() {
        return this.customAttributeKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteCustomAttributesRequest && this.equalTo((DeleteCustomAttributesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCustomAttributesRequest other) {
        return this.orderId.equals(other.orderId) && this.customAttributeKey.equals(other.customAttributeKey);
    }

    public int hashCode() {
        return Objects.hash(this.orderId, this.customAttributeKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static OrderIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements OrderIdStage,
    CustomAttributeKeyStage,
    _FinalStage {
        private String orderId;
        private String customAttributeKey;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteCustomAttributesRequest other) {
            this.orderId(other.getOrderId());
            this.customAttributeKey(other.getCustomAttributeKey());
            return this;
        }

        @Override
        @JsonSetter(value="order_id")
        public CustomAttributeKeyStage orderId(@NotNull String orderId) {
            this.orderId = Objects.requireNonNull(orderId, "orderId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_key")
        public _FinalStage customAttributeKey(@NotNull String customAttributeKey) {
            this.customAttributeKey = Objects.requireNonNull(customAttributeKey, "customAttributeKey must not be null");
            return this;
        }

        @Override
        public DeleteCustomAttributesRequest build() {
            return new DeleteCustomAttributesRequest(this.orderId, this.customAttributeKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteCustomAttributesRequest build();
    }

    public static interface CustomAttributeKeyStage {
        public _FinalStage customAttributeKey(@NotNull String var1);
    }

    public static interface OrderIdStage {
        public CustomAttributeKeyStage orderId(@NotNull String var1);

        public Builder from(DeleteCustomAttributesRequest var1);
    }
}

