/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomAttributeDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateOrderCustomAttributeDefinitionRequest {
    private final CustomAttributeDefinition customAttributeDefinition;
    private final Optional<String> idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateOrderCustomAttributeDefinitionRequest(CustomAttributeDefinition customAttributeDefinition, Optional<String> idempotencyKey, Map<String, Object> additionalProperties) {
        this.customAttributeDefinition = customAttributeDefinition;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="custom_attribute_definition")
    public CustomAttributeDefinition getCustomAttributeDefinition() {
        return this.customAttributeDefinition;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateOrderCustomAttributeDefinitionRequest && this.equalTo((CreateOrderCustomAttributeDefinitionRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrderCustomAttributeDefinitionRequest other) {
        return this.customAttributeDefinition.equals(other.customAttributeDefinition) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.customAttributeDefinition, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomAttributeDefinitionStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomAttributeDefinitionStage,
    _FinalStage {
        private CustomAttributeDefinition customAttributeDefinition;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateOrderCustomAttributeDefinitionRequest other) {
            this.customAttributeDefinition(other.getCustomAttributeDefinition());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="custom_attribute_definition")
        public _FinalStage customAttributeDefinition(@NotNull CustomAttributeDefinition customAttributeDefinition) {
            this.customAttributeDefinition = Objects.requireNonNull(customAttributeDefinition, "customAttributeDefinition must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateOrderCustomAttributeDefinitionRequest build() {
            return new CreateOrderCustomAttributeDefinitionRequest(this.customAttributeDefinition, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateOrderCustomAttributeDefinitionRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface CustomAttributeDefinitionStage {
        public _FinalStage customAttributeDefinition(@NotNull CustomAttributeDefinition var1);

        public Builder from(CreateOrderCustomAttributeDefinitionRequest var1);
    }
}

