/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.orders;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.orders.types.CreateOrderCustomAttributeDefinitionRequest;
import com.squareup.square.orders.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.orders.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.orders.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.orders.types.UpdateOrderCustomAttributeDefinitionRequest;
import com.squareup.square.types.CreateOrderCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteOrderCustomAttributeDefinitionResponse;
import com.squareup.square.types.ListOrderCustomAttributeDefinitionsResponse;
import com.squareup.square.types.RetrieveOrderCustomAttributeDefinitionResponse;
import com.squareup.square.types.UpdateOrderCustomAttributeDefinitionResponse;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;

    public RawCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.list(ListCustomAttributeDefinitionsRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/orders/custom-attribute-definitions");
        if (request.getVisibilityFilter().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "visibility_filter", request.getVisibilityFilter().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListOrderCustomAttributeDefinitionsResponse parsedResponse = (ListOrderCustomAttributeDefinitionsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListOrderCustomAttributeDefinitionsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListCustomAttributeDefinitionsRequest nextRequest = ListCustomAttributeDefinitionsRequest.builder().from(request).cursor(startingAfter).build();
                List<CustomAttributeDefinition> result = parsedResponse.getCustomAttributeDefinitions();
                SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CustomAttributeDefinition>>(new SyncPagingIterable<CustomAttributeDefinition>(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateOrderCustomAttributeDefinitionResponse> create(CreateOrderCustomAttributeDefinitionRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateOrderCustomAttributeDefinitionResponse> create(CreateOrderCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/orders/custom-attribute-definitions").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateOrderCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateOrderCustomAttributeDefinitionResponse>((CreateOrderCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateOrderCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<RetrieveOrderCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<RetrieveOrderCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/orders/custom-attribute-definitions").addPathSegment(request.getKey());
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<RetrieveOrderCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<RetrieveOrderCustomAttributeDefinitionResponse>((RetrieveOrderCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RetrieveOrderCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateOrderCustomAttributeDefinitionResponse> update(UpdateOrderCustomAttributeDefinitionRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateOrderCustomAttributeDefinitionResponse> update(UpdateOrderCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/orders/custom-attribute-definitions").addPathSegment(request.getKey()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateOrderCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateOrderCustomAttributeDefinitionResponse>((UpdateOrderCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateOrderCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<DeleteOrderCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<DeleteOrderCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/orders/custom-attribute-definitions").addPathSegment(request.getKey()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<DeleteOrderCustomAttributeDefinitionResponse> squareClientHttpResponse = new SquareClientHttpResponse<DeleteOrderCustomAttributeDefinitionResponse>((DeleteOrderCustomAttributeDefinitionResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteOrderCustomAttributeDefinitionResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

