/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.merchants;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.merchants.AsyncRawCustomAttributeDefinitionsClient;
import com.squareup.square.merchants.types.CreateMerchantCustomAttributeDefinitionRequest;
import com.squareup.square.merchants.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.merchants.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.merchants.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.merchants.types.UpdateMerchantCustomAttributeDefinitionRequest;
import com.squareup.square.types.CreateMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.types.RetrieveMerchantCustomAttributeDefinitionResponse;
import com.squareup.square.types.UpdateMerchantCustomAttributeDefinitionResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributeDefinitionsClient rawClient;

    public AsyncCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributeDefinitionsClient(clientOptions);
    }

    public AsyncRawCustomAttributeDefinitionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateMerchantCustomAttributeDefinitionResponse> create(CreateMerchantCustomAttributeDefinitionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<CreateMerchantCustomAttributeDefinitionResponse> create(CreateMerchantCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<RetrieveMerchantCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (RetrieveMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<RetrieveMerchantCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (RetrieveMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateMerchantCustomAttributeDefinitionResponse> update(UpdateMerchantCustomAttributeDefinitionRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateMerchantCustomAttributeDefinitionResponse> update(UpdateMerchantCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteMerchantCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteMerchantCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteMerchantCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteMerchantCustomAttributeDefinitionResponse)response.body());
    }
}

