/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.LoyaltyAccount;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateLoyaltyAccountRequest {
    private final LoyaltyAccount loyaltyAccount;
    private final String idempotencyKey;
    private final Map<String, Object> additionalProperties;

    private CreateLoyaltyAccountRequest(LoyaltyAccount loyaltyAccount, String idempotencyKey, Map<String, Object> additionalProperties) {
        this.loyaltyAccount = loyaltyAccount;
        this.idempotencyKey = idempotencyKey;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="loyalty_account")
    public LoyaltyAccount getLoyaltyAccount() {
        return this.loyaltyAccount;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateLoyaltyAccountRequest && this.equalTo((CreateLoyaltyAccountRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateLoyaltyAccountRequest other) {
        return this.loyaltyAccount.equals(other.loyaltyAccount) && this.idempotencyKey.equals(other.idempotencyKey);
    }

    public int hashCode() {
        return Objects.hash(this.loyaltyAccount, this.idempotencyKey);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LoyaltyAccountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LoyaltyAccountStage,
    IdempotencyKeyStage,
    _FinalStage {
        private LoyaltyAccount loyaltyAccount;
        private String idempotencyKey;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateLoyaltyAccountRequest other) {
            this.loyaltyAccount(other.getLoyaltyAccount());
            this.idempotencyKey(other.getIdempotencyKey());
            return this;
        }

        @Override
        @JsonSetter(value="loyalty_account")
        public IdempotencyKeyStage loyaltyAccount(@NotNull LoyaltyAccount loyaltyAccount) {
            this.loyaltyAccount = Objects.requireNonNull(loyaltyAccount, "loyaltyAccount must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public _FinalStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        public CreateLoyaltyAccountRequest build() {
            return new CreateLoyaltyAccountRequest(this.loyaltyAccount, this.idempotencyKey, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateLoyaltyAccountRequest build();
    }

    public static interface IdempotencyKeyStage {
        public _FinalStage idempotencyKey(@NotNull String var1);
    }

    public static interface LoyaltyAccountStage {
        public IdempotencyKeyStage loyaltyAccount(@NotNull LoyaltyAccount var1);

        public Builder from(CreateLoyaltyAccountRequest var1);
    }
}

