/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.loyalty.programs;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.loyalty.programs.AsyncRawPromotionsClient;
import com.squareup.square.loyalty.programs.types.CancelPromotionsRequest;
import com.squareup.square.loyalty.programs.types.CreateLoyaltyPromotionRequest;
import com.squareup.square.loyalty.programs.types.GetPromotionsRequest;
import com.squareup.square.loyalty.programs.types.ListPromotionsRequest;
import com.squareup.square.types.CancelLoyaltyPromotionResponse;
import com.squareup.square.types.CreateLoyaltyPromotionResponse;
import com.squareup.square.types.GetLoyaltyPromotionResponse;
import com.squareup.square.types.LoyaltyPromotion;
import java.util.concurrent.CompletableFuture;

public class AsyncPromotionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawPromotionsClient rawClient;

    public AsyncPromotionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPromotionsClient(clientOptions);
    }

    public AsyncRawPromotionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<LoyaltyPromotion>> list(ListPromotionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<LoyaltyPromotion>> list(ListPromotionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateLoyaltyPromotionResponse> create(CreateLoyaltyPromotionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateLoyaltyPromotionResponse)response.body());
    }

    public CompletableFuture<CreateLoyaltyPromotionResponse> create(CreateLoyaltyPromotionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateLoyaltyPromotionResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyPromotionResponse> get(GetPromotionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetLoyaltyPromotionResponse)response.body());
    }

    public CompletableFuture<GetLoyaltyPromotionResponse> get(GetPromotionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetLoyaltyPromotionResponse)response.body());
    }

    public CompletableFuture<CancelLoyaltyPromotionResponse> cancel(CancelPromotionsRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelLoyaltyPromotionResponse)response.body());
    }

    public CompletableFuture<CancelLoyaltyPromotionResponse> cancel(CancelPromotionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelLoyaltyPromotionResponse)response.body());
    }
}

