/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.locations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class VoidTransactionsRequest {
    private final String locationId;
    private final String transactionId;
    private final Map<String, Object> additionalProperties;

    private VoidTransactionsRequest(String locationId, String transactionId, Map<String, Object> additionalProperties) {
        this.locationId = locationId;
        this.transactionId = transactionId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="location_id")
    public String getLocationId() {
        return this.locationId;
    }

    @JsonProperty(value="transaction_id")
    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof VoidTransactionsRequest && this.equalTo((VoidTransactionsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(VoidTransactionsRequest other) {
        return this.locationId.equals(other.locationId) && this.transactionId.equals(other.transactionId);
    }

    public int hashCode() {
        return Objects.hash(this.locationId, this.transactionId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static LocationIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements LocationIdStage,
    TransactionIdStage,
    _FinalStage {
        private String locationId;
        private String transactionId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(VoidTransactionsRequest other) {
            this.locationId(other.getLocationId());
            this.transactionId(other.getTransactionId());
            return this;
        }

        @Override
        @JsonSetter(value="location_id")
        public TransactionIdStage locationId(@NotNull String locationId) {
            this.locationId = Objects.requireNonNull(locationId, "locationId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="transaction_id")
        public _FinalStage transactionId(@NotNull String transactionId) {
            this.transactionId = Objects.requireNonNull(transactionId, "transactionId must not be null");
            return this;
        }

        @Override
        public VoidTransactionsRequest build() {
            return new VoidTransactionsRequest(this.locationId, this.transactionId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public VoidTransactionsRequest build();
    }

    public static interface TransactionIdStage {
        public _FinalStage transactionId(@NotNull String var1);
    }

    public static interface LocationIdStage {
        public TransactionIdStage locationId(@NotNull String var1);

        public Builder from(VoidTransactionsRequest var1);
    }
}

