/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Shift;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdateShiftRequest {
    private final String id;
    private final Shift shift;
    private final Map<String, Object> additionalProperties;

    private UpdateShiftRequest(String id, Shift shift, Map<String, Object> additionalProperties) {
        this.id = id;
        this.shift = shift;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="shift")
    public Shift getShift() {
        return this.shift;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdateShiftRequest && this.equalTo((UpdateShiftRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateShiftRequest other) {
        return this.id.equals(other.id) && this.shift.equals(other.shift);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.shift);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    ShiftStage,
    _FinalStage {
        private String id;
        private Shift shift;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdateShiftRequest other) {
            this.id(other.getId());
            this.shift(other.getShift());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ShiftStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="shift")
        public _FinalStage shift(@NotNull Shift shift) {
            this.shift = Objects.requireNonNull(shift, "shift must not be null");
            return this;
        }

        @Override
        public UpdateShiftRequest build() {
            return new UpdateShiftRequest(this.id, this.shift, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdateShiftRequest build();
    }

    public static interface ShiftStage {
        public _FinalStage shift(@NotNull Shift var1);
    }

    public static interface IdStage {
        public ShiftStage id(@NotNull String var1);

        public Builder from(UpdateShiftRequest var1);
    }
}

