/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.labor.types.GetTeamMemberWagesRequest;
import com.squareup.square.labor.types.ListTeamMemberWagesRequest;
import com.squareup.square.types.GetTeamMemberWageResponse;
import com.squareup.square.types.ListTeamMemberWagesResponse;
import com.squareup.square.types.TeamMemberWage;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawTeamMemberWagesClient {
    protected final ClientOptions clientOptions;

    public RawTeamMemberWagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<TeamMemberWage>> list() {
        return this.list(ListTeamMemberWagesRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<TeamMemberWage>> list(ListTeamMemberWagesRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<TeamMemberWage>> list(ListTeamMemberWagesRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/labor/team-member-wages");
        if (request.getTeamMemberId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "team_member_id", request.getTeamMemberId().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListTeamMemberWagesResponse parsedResponse = (ListTeamMemberWagesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListTeamMemberWagesResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListTeamMemberWagesRequest nextRequest = ListTeamMemberWagesRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getTeamMemberWages().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<TeamMemberWage>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<TeamMemberWage>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetTeamMemberWageResponse> get(GetTeamMemberWagesRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetTeamMemberWageResponse> get(GetTeamMemberWagesRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/labor/team-member-wages").addPathSegment(request.getId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetTeamMemberWageResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetTeamMemberWageResponse>((GetTeamMemberWageResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetTeamMemberWageResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

