/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.labor;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.labor.AsyncRawBreakTypesClient;
import com.squareup.square.labor.types.CreateBreakTypeRequest;
import com.squareup.square.labor.types.DeleteBreakTypesRequest;
import com.squareup.square.labor.types.GetBreakTypesRequest;
import com.squareup.square.labor.types.ListBreakTypesRequest;
import com.squareup.square.labor.types.UpdateBreakTypeRequest;
import com.squareup.square.types.BreakType;
import com.squareup.square.types.CreateBreakTypeResponse;
import com.squareup.square.types.DeleteBreakTypeResponse;
import com.squareup.square.types.GetBreakTypeResponse;
import com.squareup.square.types.UpdateBreakTypeResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncBreakTypesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawBreakTypesClient rawClient;

    public AsyncBreakTypesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBreakTypesClient(clientOptions);
    }

    public AsyncRawBreakTypesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<BreakType>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<BreakType>> list(ListBreakTypesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<BreakType>> list(ListBreakTypesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateBreakTypeResponse> create(CreateBreakTypeRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateBreakTypeResponse)response.body());
    }

    public CompletableFuture<CreateBreakTypeResponse> create(CreateBreakTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateBreakTypeResponse)response.body());
    }

    public CompletableFuture<GetBreakTypeResponse> get(GetBreakTypesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetBreakTypeResponse)response.body());
    }

    public CompletableFuture<GetBreakTypeResponse> get(GetBreakTypesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetBreakTypeResponse)response.body());
    }

    public CompletableFuture<UpdateBreakTypeResponse> update(UpdateBreakTypeRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateBreakTypeResponse)response.body());
    }

    public CompletableFuture<UpdateBreakTypeResponse> update(UpdateBreakTypeRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateBreakTypeResponse)response.body());
    }

    public CompletableFuture<DeleteBreakTypeResponse> delete(DeleteBreakTypesRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteBreakTypeResponse)response.body());
    }

    public CompletableFuture<DeleteBreakTypeResponse> delete(DeleteBreakTypesRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteBreakTypeResponse)response.body());
    }
}

