/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class DeleteCardsRequest {
    private final String customerId;
    private final String cardId;
    private final Map<String, Object> additionalProperties;

    private DeleteCardsRequest(String customerId, String cardId, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.cardId = cardId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="card_id")
    public String getCardId() {
        return this.cardId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof DeleteCardsRequest && this.equalTo((DeleteCardsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(DeleteCardsRequest other) {
        return this.customerId.equals(other.customerId) && this.cardId.equals(other.cardId);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.cardId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    CardIdStage,
    _FinalStage {
        private String customerId;
        private String cardId;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(DeleteCardsRequest other) {
            this.customerId(other.getCustomerId());
            this.cardId(other.getCardId());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public CardIdStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="card_id")
        public _FinalStage cardId(@NotNull String cardId) {
            this.cardId = Objects.requireNonNull(cardId, "cardId must not be null");
            return this;
        }

        @Override
        public DeleteCardsRequest build() {
            return new DeleteCardsRequest(this.customerId, this.cardId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public DeleteCardsRequest build();
    }

    public static interface CardIdStage {
        public _FinalStage cardId(@NotNull String var1);
    }

    public static interface CustomerIdStage {
        public CardIdStage customerId(@NotNull String var1);

        public Builder from(DeleteCardsRequest var1);
    }
}

