/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CustomerGroup;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCustomerGroupRequest {
    private final Optional<String> idempotencyKey;
    private final CustomerGroup group;
    private final Map<String, Object> additionalProperties;

    private CreateCustomerGroupRequest(Optional<String> idempotencyKey, CustomerGroup group, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.group = group;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public Optional<String> getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="group")
    public CustomerGroup getGroup() {
        return this.group;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCustomerGroupRequest && this.equalTo((CreateCustomerGroupRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCustomerGroupRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.group.equals(other.group);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.group);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static GroupStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements GroupStage,
    _FinalStage {
        private CustomerGroup group;
        private Optional<String> idempotencyKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCustomerGroupRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.group(other.getGroup());
            return this;
        }

        @Override
        @JsonSetter(value="group")
        public _FinalStage group(@NotNull CustomerGroup group) {
            this.group = Objects.requireNonNull(group, "group must not be null");
            return this;
        }

        @Override
        public _FinalStage idempotencyKey(String idempotencyKey) {
            this.idempotencyKey = Optional.ofNullable(idempotencyKey);
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key", nulls=Nulls.SKIP)
        public _FinalStage idempotencyKey(Optional<String> idempotencyKey) {
            this.idempotencyKey = idempotencyKey;
            return this;
        }

        @Override
        public CreateCustomerGroupRequest build() {
            return new CreateCustomerGroupRequest(this.idempotencyKey, this.group, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCustomerGroupRequest build();

        public _FinalStage idempotencyKey(Optional<String> var1);

        public _FinalStage idempotencyKey(String var1);
    }

    public static interface GroupStage {
        public _FinalStage group(@NotNull CustomerGroup var1);

        public Builder from(CreateCustomerGroupRequest var1);
    }
}

