/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.Address;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCustomerCardRequest {
    private final String customerId;
    private final String cardNonce;
    private final Optional<Address> billingAddress;
    private final Optional<String> cardholderName;
    private final Optional<String> verificationToken;
    private final Map<String, Object> additionalProperties;

    private CreateCustomerCardRequest(String customerId, String cardNonce, Optional<Address> billingAddress, Optional<String> cardholderName, Optional<String> verificationToken, Map<String, Object> additionalProperties) {
        this.customerId = customerId;
        this.cardNonce = cardNonce;
        this.billingAddress = billingAddress;
        this.cardholderName = cardholderName;
        this.verificationToken = verificationToken;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="customer_id")
    public String getCustomerId() {
        return this.customerId;
    }

    @JsonProperty(value="card_nonce")
    public String getCardNonce() {
        return this.cardNonce;
    }

    @JsonProperty(value="billing_address")
    public Optional<Address> getBillingAddress() {
        return this.billingAddress;
    }

    @JsonProperty(value="cardholder_name")
    public Optional<String> getCardholderName() {
        return this.cardholderName;
    }

    @JsonProperty(value="verification_token")
    public Optional<String> getVerificationToken() {
        return this.verificationToken;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCustomerCardRequest && this.equalTo((CreateCustomerCardRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCustomerCardRequest other) {
        return this.customerId.equals(other.customerId) && this.cardNonce.equals(other.cardNonce) && this.billingAddress.equals(other.billingAddress) && this.cardholderName.equals(other.cardholderName) && this.verificationToken.equals(other.verificationToken);
    }

    public int hashCode() {
        return Objects.hash(this.customerId, this.cardNonce, this.billingAddress, this.cardholderName, this.verificationToken);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerIdStage,
    CardNonceStage,
    _FinalStage {
        private String customerId;
        private String cardNonce;
        private Optional<String> verificationToken = Optional.empty();
        private Optional<String> cardholderName = Optional.empty();
        private Optional<Address> billingAddress = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCustomerCardRequest other) {
            this.customerId(other.getCustomerId());
            this.cardNonce(other.getCardNonce());
            this.billingAddress(other.getBillingAddress());
            this.cardholderName(other.getCardholderName());
            this.verificationToken(other.getVerificationToken());
            return this;
        }

        @Override
        @JsonSetter(value="customer_id")
        public CardNonceStage customerId(@NotNull String customerId) {
            this.customerId = Objects.requireNonNull(customerId, "customerId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="card_nonce")
        public _FinalStage cardNonce(@NotNull String cardNonce) {
            this.cardNonce = Objects.requireNonNull(cardNonce, "cardNonce must not be null");
            return this;
        }

        @Override
        public _FinalStage verificationToken(String verificationToken) {
            this.verificationToken = Optional.ofNullable(verificationToken);
            return this;
        }

        @Override
        @JsonSetter(value="verification_token", nulls=Nulls.SKIP)
        public _FinalStage verificationToken(Optional<String> verificationToken) {
            this.verificationToken = verificationToken;
            return this;
        }

        @Override
        public _FinalStage cardholderName(String cardholderName) {
            this.cardholderName = Optional.ofNullable(cardholderName);
            return this;
        }

        @Override
        @JsonSetter(value="cardholder_name", nulls=Nulls.SKIP)
        public _FinalStage cardholderName(Optional<String> cardholderName) {
            this.cardholderName = cardholderName;
            return this;
        }

        @Override
        public _FinalStage billingAddress(Address billingAddress) {
            this.billingAddress = Optional.ofNullable(billingAddress);
            return this;
        }

        @Override
        @JsonSetter(value="billing_address", nulls=Nulls.SKIP)
        public _FinalStage billingAddress(Optional<Address> billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        @Override
        public CreateCustomerCardRequest build() {
            return new CreateCustomerCardRequest(this.customerId, this.cardNonce, this.billingAddress, this.cardholderName, this.verificationToken, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCustomerCardRequest build();

        public _FinalStage billingAddress(Optional<Address> var1);

        public _FinalStage billingAddress(Address var1);

        public _FinalStage cardholderName(Optional<String> var1);

        public _FinalStage cardholderName(String var1);

        public _FinalStage verificationToken(Optional<String> var1);

        public _FinalStage verificationToken(String var1);
    }

    public static interface CardNonceStage {
        public _FinalStage cardNonce(@NotNull String var1);
    }

    public static interface CustomerIdStage {
        public CardNonceStage customerId(@NotNull String var1);

        public Builder from(CreateCustomerCardRequest var1);
    }
}

