/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.RawSegmentsClient;
import com.squareup.square.customers.types.GetSegmentsRequest;
import com.squareup.square.customers.types.ListSegmentsRequest;
import com.squareup.square.types.CustomerSegment;
import com.squareup.square.types.GetCustomerSegmentResponse;

public class SegmentsClient {
    protected final ClientOptions clientOptions;
    private final RawSegmentsClient rawClient;

    public SegmentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawSegmentsClient(clientOptions);
    }

    public RawSegmentsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<CustomerSegment> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<CustomerSegment> list(ListSegmentsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<CustomerSegment> list(ListSegmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public GetCustomerSegmentResponse get(GetSegmentsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetCustomerSegmentResponse get(GetSegmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }
}

