/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.AsyncRawSegmentsClient;
import com.squareup.square.customers.types.GetSegmentsRequest;
import com.squareup.square.customers.types.ListSegmentsRequest;
import com.squareup.square.types.CustomerSegment;
import com.squareup.square.types.GetCustomerSegmentResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncSegmentsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawSegmentsClient rawClient;

    public AsyncSegmentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawSegmentsClient(clientOptions);
    }

    public AsyncRawSegmentsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomerSegment>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomerSegment>> list(ListSegmentsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomerSegment>> list(ListSegmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetCustomerSegmentResponse> get(GetSegmentsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCustomerSegmentResponse)response.body());
    }

    public CompletableFuture<GetCustomerSegmentResponse> get(GetSegmentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCustomerSegmentResponse)response.body());
    }
}

