/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.customers;

import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.customers.AsyncRawCustomAttributeDefinitionsClient;
import com.squareup.square.customers.types.BatchUpsertCustomerCustomAttributesRequest;
import com.squareup.square.customers.types.CreateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.customers.types.DeleteCustomAttributeDefinitionsRequest;
import com.squareup.square.customers.types.GetCustomAttributeDefinitionsRequest;
import com.squareup.square.customers.types.ListCustomAttributeDefinitionsRequest;
import com.squareup.square.customers.types.UpdateCustomerCustomAttributeDefinitionRequest;
import com.squareup.square.types.BatchUpsertCustomerCustomAttributesResponse;
import com.squareup.square.types.CreateCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.types.CustomAttributeDefinition;
import com.squareup.square.types.DeleteCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.types.GetCustomerCustomAttributeDefinitionResponse;
import com.squareup.square.types.UpdateCustomerCustomAttributeDefinitionResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncCustomAttributeDefinitionsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCustomAttributeDefinitionsClient rawClient;

    public AsyncCustomAttributeDefinitionsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCustomAttributeDefinitionsClient(clientOptions);
    }

    public AsyncRawCustomAttributeDefinitionsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<CustomAttributeDefinition>> list(ListCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateCustomerCustomAttributeDefinitionResponse> create(CreateCustomerCustomAttributeDefinitionRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<CreateCustomerCustomAttributeDefinitionResponse> create(CreateCustomerCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<GetCustomerCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<GetCustomerCustomAttributeDefinitionResponse> get(GetCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateCustomerCustomAttributeDefinitionResponse> update(UpdateCustomerCustomAttributeDefinitionRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<UpdateCustomerCustomAttributeDefinitionResponse> update(UpdateCustomerCustomAttributeDefinitionRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeleteCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<DeleteCustomerCustomAttributeDefinitionResponse> delete(DeleteCustomAttributeDefinitionsRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeleteCustomerCustomAttributeDefinitionResponse)response.body());
    }

    public CompletableFuture<BatchUpsertCustomerCustomAttributesResponse> batchUpsert(BatchUpsertCustomerCustomAttributesRequest request) {
        return this.rawClient.batchUpsert(request).thenApply(response -> (BatchUpsertCustomerCustomAttributesResponse)response.body());
    }

    public CompletableFuture<BatchUpsertCustomerCustomAttributesResponse> batchUpsert(BatchUpsertCustomerCustomAttributesRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpsert(request, requestOptions).thenApply(response -> (BatchUpsertCustomerCustomAttributesResponse)response.body());
    }
}

