/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.checkout.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.PaymentLink;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpdatePaymentLinkRequest {
    private final String id;
    private final PaymentLink paymentLink;
    private final Map<String, Object> additionalProperties;

    private UpdatePaymentLinkRequest(String id, PaymentLink paymentLink, Map<String, Object> additionalProperties) {
        this.id = id;
        this.paymentLink = paymentLink;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="payment_link")
    public PaymentLink getPaymentLink() {
        return this.paymentLink;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpdatePaymentLinkRequest && this.equalTo((UpdatePaymentLinkRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePaymentLinkRequest other) {
        return this.id.equals(other.id) && this.paymentLink.equals(other.paymentLink);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.paymentLink);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    PaymentLinkStage,
    _FinalStage {
        private String id;
        private PaymentLink paymentLink;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpdatePaymentLinkRequest other) {
            this.id(other.getId());
            this.paymentLink(other.getPaymentLink());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public PaymentLinkStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="payment_link")
        public _FinalStage paymentLink(@NotNull PaymentLink paymentLink) {
            this.paymentLink = Objects.requireNonNull(paymentLink, "paymentLink must not be null");
            return this;
        }

        @Override
        public UpdatePaymentLinkRequest build() {
            return new UpdatePaymentLinkRequest(this.id, this.paymentLink, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpdatePaymentLinkRequest build();
    }

    public static interface PaymentLinkStage {
        public _FinalStage paymentLink(@NotNull PaymentLink var1);
    }

    public static interface IdStage {
        public PaymentLinkStage id(@NotNull String var1);

        public Builder from(UpdatePaymentLinkRequest var1);
    }
}

