/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.checkout;

import com.squareup.square.checkout.AsyncRawPaymentLinksClient;
import com.squareup.square.checkout.types.CreatePaymentLinkRequest;
import com.squareup.square.checkout.types.DeletePaymentLinksRequest;
import com.squareup.square.checkout.types.GetPaymentLinksRequest;
import com.squareup.square.checkout.types.ListPaymentLinksRequest;
import com.squareup.square.checkout.types.UpdatePaymentLinkRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CreatePaymentLinkResponse;
import com.squareup.square.types.DeletePaymentLinkResponse;
import com.squareup.square.types.GetPaymentLinkResponse;
import com.squareup.square.types.PaymentLink;
import com.squareup.square.types.UpdatePaymentLinkResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncPaymentLinksClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawPaymentLinksClient rawClient;

    public AsyncPaymentLinksClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPaymentLinksClient(clientOptions);
    }

    public AsyncRawPaymentLinksClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<PaymentLink>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<PaymentLink>> list(ListPaymentLinksRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<PaymentLink>> list(ListPaymentLinksRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreatePaymentLinkResponse> create() {
        return this.rawClient.create().thenApply(response -> (CreatePaymentLinkResponse)response.body());
    }

    public CompletableFuture<CreatePaymentLinkResponse> create(CreatePaymentLinkRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreatePaymentLinkResponse)response.body());
    }

    public CompletableFuture<CreatePaymentLinkResponse> create(CreatePaymentLinkRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreatePaymentLinkResponse)response.body());
    }

    public CompletableFuture<GetPaymentLinkResponse> get(GetPaymentLinksRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetPaymentLinkResponse)response.body());
    }

    public CompletableFuture<GetPaymentLinkResponse> get(GetPaymentLinksRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetPaymentLinkResponse)response.body());
    }

    public CompletableFuture<UpdatePaymentLinkResponse> update(UpdatePaymentLinkRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdatePaymentLinkResponse)response.body());
    }

    public CompletableFuture<UpdatePaymentLinkResponse> update(UpdatePaymentLinkRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdatePaymentLinkResponse)response.body());
    }

    public CompletableFuture<DeletePaymentLinkResponse> delete(DeletePaymentLinksRequest request) {
        return this.rawClient.delete(request).thenApply(response -> (DeletePaymentLinkResponse)response.body());
    }

    public CompletableFuture<DeletePaymentLinkResponse> delete(DeletePaymentLinksRequest request, RequestOptions requestOptions) {
        return this.rawClient.delete(request, requestOptions).thenApply(response -> (DeletePaymentLinkResponse)response.body());
    }
}

