/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.types.CatalogObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UpsertCatalogObjectRequest {
    private final String idempotencyKey;
    private final CatalogObject object;
    private final Map<String, Object> additionalProperties;

    private UpsertCatalogObjectRequest(String idempotencyKey, CatalogObject object, Map<String, Object> additionalProperties) {
        this.idempotencyKey = idempotencyKey;
        this.object = object;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="idempotency_key")
    public String getIdempotencyKey() {
        return this.idempotencyKey;
    }

    @JsonProperty(value="object")
    public CatalogObject getObject() {
        return this.object;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UpsertCatalogObjectRequest && this.equalTo((UpsertCatalogObjectRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpsertCatalogObjectRequest other) {
        return this.idempotencyKey.equals(other.idempotencyKey) && this.object.equals(other.object);
    }

    public int hashCode() {
        return Objects.hash(this.idempotencyKey, this.object);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdempotencyKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdempotencyKeyStage,
    ObjectStage,
    _FinalStage {
        private String idempotencyKey;
        private CatalogObject object;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UpsertCatalogObjectRequest other) {
            this.idempotencyKey(other.getIdempotencyKey());
            this.object(other.getObject());
            return this;
        }

        @Override
        @JsonSetter(value="idempotency_key")
        public ObjectStage idempotencyKey(@NotNull String idempotencyKey) {
            this.idempotencyKey = Objects.requireNonNull(idempotencyKey, "idempotencyKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="object")
        public _FinalStage object(@NotNull CatalogObject object) {
            this.object = Objects.requireNonNull(object, "object must not be null");
            return this;
        }

        @Override
        public UpsertCatalogObjectRequest build() {
            return new UpsertCatalogObjectRequest(this.idempotencyKey, this.object, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UpsertCatalogObjectRequest build();
    }

    public static interface ObjectStage {
        public _FinalStage object(@NotNull CatalogObject var1);
    }

    public static interface IdempotencyKeyStage {
        public ObjectStage idempotencyKey(@NotNull String var1);

        public Builder from(UpsertCatalogObjectRequest var1);
    }
}

