/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.catalog;

import com.squareup.square.catalog.AsyncRawImagesClient;
import com.squareup.square.catalog.types.CreateImagesRequest;
import com.squareup.square.catalog.types.UpdateImagesRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.CreateCatalogImageResponse;
import com.squareup.square.types.UpdateCatalogImageResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncImagesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawImagesClient rawClient;

    public AsyncImagesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawImagesClient(clientOptions);
    }

    public AsyncRawImagesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateCatalogImageResponse> create() {
        return this.rawClient.create().thenApply(response -> (CreateCatalogImageResponse)response.body());
    }

    public CompletableFuture<CreateCatalogImageResponse> create(CreateImagesRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateCatalogImageResponse)response.body());
    }

    public CompletableFuture<CreateCatalogImageResponse> create(CreateImagesRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateCatalogImageResponse)response.body());
    }

    public CompletableFuture<UpdateCatalogImageResponse> update(UpdateImagesRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateCatalogImageResponse)response.body());
    }

    public CompletableFuture<UpdateCatalogImageResponse> update(UpdateImagesRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateCatalogImageResponse)response.body());
    }
}

