/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.cashdrawers;

import com.squareup.square.cashdrawers.types.GetShiftsRequest;
import com.squareup.square.cashdrawers.types.ListEventsShiftsRequest;
import com.squareup.square.cashdrawers.types.ListShiftsRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CashDrawerShiftEvent;
import com.squareup.square.types.CashDrawerShiftSummary;
import com.squareup.square.types.GetCashDrawerShiftResponse;
import com.squareup.square.types.ListCashDrawerShiftEventsResponse;
import com.squareup.square.types.ListCashDrawerShiftsResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawShiftsClient {
    protected final ClientOptions clientOptions;

    public RawShiftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>> list(ListShiftsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>> list(ListShiftsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cash-drawers/shifts");
        QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId(), false);
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getBeginTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "begin_time", request.getBeginTime().get(), false);
        }
        if (request.getEndTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "end_time", request.getEndTime().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListCashDrawerShiftsResponse parsedResponse = (ListCashDrawerShiftsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCashDrawerShiftsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListShiftsRequest nextRequest = ListShiftsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCashDrawerShifts().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetCashDrawerShiftResponse> get(GetShiftsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetCashDrawerShiftResponse> get(GetShiftsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cash-drawers/shifts").addPathSegment(request.getShiftId());
        QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetCashDrawerShiftResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetCashDrawerShiftResponse>((GetCashDrawerShiftResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCashDrawerShiftResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>> listEvents(ListEventsShiftsRequest request) {
        return this.listEvents(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>> listEvents(ListEventsShiftsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cash-drawers/shifts").addPathSegment(request.getShiftId()).addPathSegments("events");
        QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListCashDrawerShiftEventsResponse parsedResponse = (ListCashDrawerShiftEventsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCashDrawerShiftEventsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListEventsShiftsRequest nextRequest = ListEventsShiftsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCashDrawerShiftEvents().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.listEvents(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

