/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square.cashdrawers;

import com.squareup.square.cashdrawers.types.GetShiftsRequest;
import com.squareup.square.cashdrawers.types.ListEventsShiftsRequest;
import com.squareup.square.cashdrawers.types.ListShiftsRequest;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CashDrawerShiftEvent;
import com.squareup.square.types.CashDrawerShiftSummary;
import com.squareup.square.types.GetCashDrawerShiftResponse;
import com.squareup.square.types.ListCashDrawerShiftEventsResponse;
import com.squareup.square.types.ListCashDrawerShiftsResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawShiftsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawShiftsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>>> list(ListShiftsRequest request) {
        return this.list(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>>> list(final ListShiftsRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cash-drawers/shifts");
        QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId(), false);
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getBeginTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "begin_time", request.getBeginTime().get(), false);
        }
        if (request.getEndTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "end_time", request.getEndTime().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftSummary>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        ListCashDrawerShiftsResponse parsedResponse = (ListCashDrawerShiftsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCashDrawerShiftsResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        ListShiftsRequest nextRequest = ListShiftsRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getCashDrawerShifts().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawShiftsClient.this.list(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetCashDrawerShiftResponse>> get(GetShiftsRequest request) {
        return this.get(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetCashDrawerShiftResponse>> get(GetShiftsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cash-drawers/shifts").addPathSegment(request.getShiftId());
        QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId(), false);
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetCashDrawerShiftResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetCashDrawerShiftResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetCashDrawerShiftResponse>((GetCashDrawerShiftResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCashDrawerShiftResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>>> listEvents(ListEventsShiftsRequest request) {
        return this.listEvents(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>>> listEvents(final ListEventsShiftsRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cash-drawers/shifts").addPathSegment(request.getShiftId()).addPathSegments("events");
        QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId(), false);
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<CashDrawerShiftEvent>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        ListCashDrawerShiftEventsResponse parsedResponse = (ListCashDrawerShiftEventsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCashDrawerShiftEventsResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        ListEventsShiftsRequest nextRequest = ListEventsShiftsRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getCashDrawerShiftEvents().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawShiftsClient.this.listEvents(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

