/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CancelPaymentByIdempotencyKeyRequest;
import com.squareup.square.types.CancelPaymentByIdempotencyKeyResponse;
import com.squareup.square.types.CancelPaymentResponse;
import com.squareup.square.types.CancelPaymentsRequest;
import com.squareup.square.types.CompletePaymentRequest;
import com.squareup.square.types.CompletePaymentResponse;
import com.squareup.square.types.CreatePaymentRequest;
import com.squareup.square.types.CreatePaymentResponse;
import com.squareup.square.types.GetPaymentResponse;
import com.squareup.square.types.GetPaymentsRequest;
import com.squareup.square.types.ListPaymentsRequest;
import com.squareup.square.types.ListPaymentsResponse;
import com.squareup.square.types.Payment;
import com.squareup.square.types.UpdatePaymentRequest;
import com.squareup.square.types.UpdatePaymentResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawPaymentsClient {
    protected final ClientOptions clientOptions;

    public RawPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<Payment>> list() {
        return this.list(ListPaymentsRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<Payment>> list(ListPaymentsRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<Payment>> list(ListPaymentsRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments");
        if (request.getBeginTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "begin_time", request.getBeginTime().get(), false);
        }
        if (request.getEndTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "end_time", request.getEndTime().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLocationId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId().get(), false);
        }
        if (request.getTotal().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "total", request.getTotal().get(), false);
        }
        if (request.getLast4().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "last_4", request.getLast4().get(), false);
        }
        if (request.getCardBrand().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "card_brand", request.getCardBrand().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getIsOfflinePayment().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "is_offline_payment", request.getIsOfflinePayment().get(), false);
        }
        if (request.getOfflineBeginTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offline_begin_time", request.getOfflineBeginTime().get(), false);
        }
        if (request.getOfflineEndTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "offline_end_time", request.getOfflineEndTime().get(), false);
        }
        if (request.getUpdatedAtBeginTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "updated_at_begin_time", request.getUpdatedAtBeginTime().get(), false);
        }
        if (request.getUpdatedAtEndTime().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "updated_at_end_time", request.getUpdatedAtEndTime().get(), false);
        }
        if (request.getSortField().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_field", request.getSortField().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListPaymentsResponse parsedResponse = (ListPaymentsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListPaymentsResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListPaymentsRequest nextRequest = ListPaymentsRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getPayments().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<Payment>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<Payment>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreatePaymentResponse> create(CreatePaymentRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreatePaymentResponse> create(CreatePaymentRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreatePaymentResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreatePaymentResponse>((CreatePaymentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreatePaymentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CancelPaymentByIdempotencyKeyResponse> cancelByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest request) {
        return this.cancelByIdempotencyKey(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CancelPaymentByIdempotencyKeyResponse> cancelByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments/cancel").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CancelPaymentByIdempotencyKeyResponse> squareClientHttpResponse = new SquareClientHttpResponse<CancelPaymentByIdempotencyKeyResponse>((CancelPaymentByIdempotencyKeyResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CancelPaymentByIdempotencyKeyResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetPaymentResponse> get(GetPaymentsRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetPaymentResponse> get(GetPaymentsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments").addPathSegment(request.getPaymentId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetPaymentResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetPaymentResponse>((GetPaymentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetPaymentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdatePaymentResponse> update(UpdatePaymentRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdatePaymentResponse> update(UpdatePaymentRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments").addPathSegment(request.getPaymentId()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdatePaymentResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdatePaymentResponse>((UpdatePaymentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdatePaymentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CancelPaymentResponse> cancel(CancelPaymentsRequest request) {
        return this.cancel(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CancelPaymentResponse> cancel(CancelPaymentsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments").addPathSegment(request.getPaymentId()).addPathSegments("cancel").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CancelPaymentResponse> squareClientHttpResponse = new SquareClientHttpResponse<CancelPaymentResponse>((CancelPaymentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CancelPaymentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CompletePaymentResponse> complete(CompletePaymentRequest request) {
        return this.complete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CompletePaymentResponse> complete(CompletePaymentRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/payments").addPathSegment(request.getPaymentId()).addPathSegments("complete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CompletePaymentResponse> squareClientHttpResponse = new SquareClientHttpResponse<CompletePaymentResponse>((CompletePaymentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CompletePaymentResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

