/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BulkCreateCustomersRequest;
import com.squareup.square.types.BulkCreateCustomersResponse;
import com.squareup.square.types.BulkDeleteCustomersRequest;
import com.squareup.square.types.BulkDeleteCustomersResponse;
import com.squareup.square.types.BulkRetrieveCustomersRequest;
import com.squareup.square.types.BulkRetrieveCustomersResponse;
import com.squareup.square.types.BulkUpdateCustomersRequest;
import com.squareup.square.types.BulkUpdateCustomersResponse;
import com.squareup.square.types.CreateCustomerRequest;
import com.squareup.square.types.CreateCustomerResponse;
import com.squareup.square.types.Customer;
import com.squareup.square.types.DeleteCustomerResponse;
import com.squareup.square.types.DeleteCustomersRequest;
import com.squareup.square.types.GetCustomerResponse;
import com.squareup.square.types.GetCustomersRequest;
import com.squareup.square.types.ListCustomersRequest;
import com.squareup.square.types.ListCustomersResponse;
import com.squareup.square.types.SearchCustomersRequest;
import com.squareup.square.types.SearchCustomersResponse;
import com.squareup.square.types.UpdateCustomerRequest;
import com.squareup.square.types.UpdateCustomerResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCustomersClient {
    protected final ClientOptions clientOptions;

    public RawCustomersClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<SyncPagingIterable<Customer>> list() {
        return this.list(ListCustomersRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<Customer>> list(ListCustomersRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<Customer>> list(ListCustomersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers");
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getSortField().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_field", request.getSortField().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        if (request.getCount().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "count", request.getCount().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListCustomersResponse parsedResponse = (ListCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCustomersResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListCustomersRequest nextRequest = ListCustomersRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getCustomers().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<Customer>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<Customer>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CreateCustomerResponse> create() {
        return this.create(CreateCustomerRequest.builder().build());
    }

    public SquareClientHttpResponse<CreateCustomerResponse> create(CreateCustomerRequest request) {
        return this.create(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CreateCustomerResponse> create(CreateCustomerRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CreateCustomerResponse> squareClientHttpResponse = new SquareClientHttpResponse<CreateCustomerResponse>((CreateCustomerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCustomerResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BulkCreateCustomersResponse> batchCreate(BulkCreateCustomersRequest request) {
        return this.batchCreate(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BulkCreateCustomersResponse> batchCreate(BulkCreateCustomersRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/bulk-create").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BulkCreateCustomersResponse> squareClientHttpResponse = new SquareClientHttpResponse<BulkCreateCustomersResponse>((BulkCreateCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkCreateCustomersResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BulkDeleteCustomersResponse> bulkDeleteCustomers(BulkDeleteCustomersRequest request) {
        return this.bulkDeleteCustomers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BulkDeleteCustomersResponse> bulkDeleteCustomers(BulkDeleteCustomersRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/bulk-delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BulkDeleteCustomersResponse> squareClientHttpResponse = new SquareClientHttpResponse<BulkDeleteCustomersResponse>((BulkDeleteCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkDeleteCustomersResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BulkRetrieveCustomersResponse> bulkRetrieveCustomers(BulkRetrieveCustomersRequest request) {
        return this.bulkRetrieveCustomers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BulkRetrieveCustomersResponse> bulkRetrieveCustomers(BulkRetrieveCustomersRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/bulk-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BulkRetrieveCustomersResponse> squareClientHttpResponse = new SquareClientHttpResponse<BulkRetrieveCustomersResponse>((BulkRetrieveCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkRetrieveCustomersResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BulkUpdateCustomersResponse> bulkUpdateCustomers(BulkUpdateCustomersRequest request) {
        return this.bulkUpdateCustomers(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BulkUpdateCustomersResponse> bulkUpdateCustomers(BulkUpdateCustomersRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/bulk-update").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BulkUpdateCustomersResponse> squareClientHttpResponse = new SquareClientHttpResponse<BulkUpdateCustomersResponse>((BulkUpdateCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkUpdateCustomersResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SearchCustomersResponse> search() {
        return this.search(SearchCustomersRequest.builder().build());
    }

    public SquareClientHttpResponse<SearchCustomersResponse> search(SearchCustomersRequest request) {
        return this.search(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SearchCustomersResponse> search(SearchCustomersRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers/search").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<SearchCustomersResponse> squareClientHttpResponse = new SquareClientHttpResponse<SearchCustomersResponse>((SearchCustomersResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchCustomersResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<GetCustomerResponse> get(GetCustomersRequest request) {
        return this.get(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<GetCustomerResponse> get(GetCustomersRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers").addPathSegment(request.getCustomerId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<GetCustomerResponse> squareClientHttpResponse = new SquareClientHttpResponse<GetCustomerResponse>((GetCustomerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCustomerResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateCustomerResponse> update(UpdateCustomerRequest request) {
        return this.update(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateCustomerResponse> update(UpdateCustomerRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers").addPathSegment(request.getCustomerId()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateCustomerResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateCustomerResponse>((UpdateCustomerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateCustomerResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<DeleteCustomerResponse> delete(DeleteCustomersRequest request) {
        return this.delete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<DeleteCustomerResponse> delete(DeleteCustomersRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/customers").addPathSegment(request.getCustomerId());
        if (request.getVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "version", request.getVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("DELETE", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<DeleteCustomerResponse> squareClientHttpResponse = new SquareClientHttpResponse<DeleteCustomerResponse>((DeleteCustomerResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DeleteCustomerResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

