/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BatchDeleteCatalogObjectsRequest;
import com.squareup.square.types.BatchDeleteCatalogObjectsResponse;
import com.squareup.square.types.BatchGetCatalogObjectsRequest;
import com.squareup.square.types.BatchGetCatalogObjectsResponse;
import com.squareup.square.types.BatchUpsertCatalogObjectsRequest;
import com.squareup.square.types.BatchUpsertCatalogObjectsResponse;
import com.squareup.square.types.CatalogInfoResponse;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.ListCatalogRequest;
import com.squareup.square.types.ListCatalogResponse;
import com.squareup.square.types.SearchCatalogItemsRequest;
import com.squareup.square.types.SearchCatalogItemsResponse;
import com.squareup.square.types.SearchCatalogObjectsRequest;
import com.squareup.square.types.SearchCatalogObjectsResponse;
import com.squareup.square.types.UpdateItemModifierListsRequest;
import com.squareup.square.types.UpdateItemModifierListsResponse;
import com.squareup.square.types.UpdateItemTaxesRequest;
import com.squareup.square.types.UpdateItemTaxesResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class RawCatalogClient {
    protected final ClientOptions clientOptions;

    public RawCatalogClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public SquareClientHttpResponse<BatchDeleteCatalogObjectsResponse> batchDelete(BatchDeleteCatalogObjectsRequest request) {
        return this.batchDelete(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchDeleteCatalogObjectsResponse> batchDelete(BatchDeleteCatalogObjectsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/batch-delete").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchDeleteCatalogObjectsResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchDeleteCatalogObjectsResponse>((BatchDeleteCatalogObjectsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchDeleteCatalogObjectsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchGetCatalogObjectsResponse> batchGet(BatchGetCatalogObjectsRequest request) {
        return this.batchGet(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchGetCatalogObjectsResponse> batchGet(BatchGetCatalogObjectsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/batch-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchGetCatalogObjectsResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchGetCatalogObjectsResponse>((BatchGetCatalogObjectsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetCatalogObjectsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<BatchUpsertCatalogObjectsResponse> batchUpsert(BatchUpsertCatalogObjectsRequest request) {
        return this.batchUpsert(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<BatchUpsertCatalogObjectsResponse> batchUpsert(BatchUpsertCatalogObjectsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/batch-upsert").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<BatchUpsertCatalogObjectsResponse> squareClientHttpResponse = new SquareClientHttpResponse<BatchUpsertCatalogObjectsResponse>((BatchUpsertCatalogObjectsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchUpsertCatalogObjectsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<CatalogInfoResponse> info() {
        return this.info(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<CatalogInfoResponse> info(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/info").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<CatalogInfoResponse> squareClientHttpResponse = new SquareClientHttpResponse<CatalogInfoResponse>((CatalogInfoResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CatalogInfoResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SyncPagingIterable<CatalogObject>> list() {
        return this.list(ListCatalogRequest.builder().build());
    }

    public SquareClientHttpResponse<SyncPagingIterable<CatalogObject>> list(ListCatalogRequest request) {
        return this.list(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SyncPagingIterable<CatalogObject>> list(ListCatalogRequest request, RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/list");
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getTypes().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "types", request.getTypes().get(), false);
        }
        if (request.getCatalogVersion().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "catalog_version", request.getCatalogVersion().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                ListCatalogResponse parsedResponse = (ListCatalogResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCatalogResponse.class);
                Optional<String> startingAfter = parsedResponse.getCursor();
                ListCatalogRequest nextRequest = ListCatalogRequest.builder().from(request).cursor(startingAfter).build();
                List result = parsedResponse.getObjects().orElse(Collections.emptyList());
                SquareClientHttpResponse<SyncPagingIterable<CatalogObject>> squareClientHttpResponse = new SquareClientHttpResponse<SyncPagingIterable<CatalogObject>>(new SyncPagingIterable(startingAfter.isPresent(), result, () -> this.list(nextRequest, requestOptions).body()), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SearchCatalogObjectsResponse> search() {
        return this.search(SearchCatalogObjectsRequest.builder().build());
    }

    public SquareClientHttpResponse<SearchCatalogObjectsResponse> search(SearchCatalogObjectsRequest request) {
        return this.search(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SearchCatalogObjectsResponse> search(SearchCatalogObjectsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/search").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<SearchCatalogObjectsResponse> squareClientHttpResponse = new SquareClientHttpResponse<SearchCatalogObjectsResponse>((SearchCatalogObjectsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchCatalogObjectsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<SearchCatalogItemsResponse> searchItems() {
        return this.searchItems(SearchCatalogItemsRequest.builder().build());
    }

    public SquareClientHttpResponse<SearchCatalogItemsResponse> searchItems(SearchCatalogItemsRequest request) {
        return this.searchItems(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<SearchCatalogItemsResponse> searchItems(SearchCatalogItemsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/search-catalog-items").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<SearchCatalogItemsResponse> squareClientHttpResponse = new SquareClientHttpResponse<SearchCatalogItemsResponse>((SearchCatalogItemsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchCatalogItemsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateItemModifierListsResponse> updateItemModifierLists(UpdateItemModifierListsRequest request) {
        return this.updateItemModifierLists(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateItemModifierListsResponse> updateItemModifierLists(UpdateItemModifierListsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/update-item-modifier-lists").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateItemModifierListsResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateItemModifierListsResponse>((UpdateItemModifierListsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateItemModifierListsResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }

    public SquareClientHttpResponse<UpdateItemTaxesResponse> updateItemTaxes(UpdateItemTaxesRequest request) {
        return this.updateItemTaxes(request, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SquareClientHttpResponse<UpdateItemTaxesResponse> updateItemTaxes(UpdateItemTaxesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/catalog/update-item-taxes").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        try (Response response = client.newCall(okhttpRequest).execute();){
            ResponseBody responseBody = response.body();
            if (response.isSuccessful()) {
                SquareClientHttpResponse<UpdateItemTaxesResponse> squareClientHttpResponse = new SquareClientHttpResponse<UpdateItemTaxesResponse>((UpdateItemTaxesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateItemTaxesResponse.class), response);
                return squareClientHttpResponse;
            }
            String responseBodyString = responseBody != null ? responseBody.string() : "{}";
            throw new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response);
        }
        catch (IOException e) {
            throw new SquareException("Network error executing HTTP request", e);
        }
    }
}

