/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawOAuthClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.ObtainTokenRequest;
import com.squareup.square.types.ObtainTokenResponse;
import com.squareup.square.types.RetrieveTokenStatusResponse;
import com.squareup.square.types.RevokeTokenRequest;
import com.squareup.square.types.RevokeTokenResponse;

public class OAuthClient {
    protected final ClientOptions clientOptions;
    private final RawOAuthClient rawClient;

    public OAuthClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawOAuthClient(clientOptions);
    }

    public RawOAuthClient withRawResponse() {
        return this.rawClient;
    }

    public RevokeTokenResponse revokeToken() {
        return this.rawClient.revokeToken().body();
    }

    public RevokeTokenResponse revokeToken(RevokeTokenRequest request) {
        return this.rawClient.revokeToken(request).body();
    }

    public RevokeTokenResponse revokeToken(RevokeTokenRequest request, RequestOptions requestOptions) {
        return this.rawClient.revokeToken(request, requestOptions).body();
    }

    public ObtainTokenResponse obtainToken(ObtainTokenRequest request) {
        return this.rawClient.obtainToken(request).body();
    }

    public ObtainTokenResponse obtainToken(ObtainTokenRequest request, RequestOptions requestOptions) {
        return this.rawClient.obtainToken(request, requestOptions).body();
    }

    public RetrieveTokenStatusResponse retrieveTokenStatus() {
        return this.rawClient.retrieveTokenStatus().body();
    }

    public RetrieveTokenStatusResponse retrieveTokenStatus(RequestOptions requestOptions) {
        return this.rawClient.retrieveTokenStatus(requestOptions).body();
    }

    public void authorize() {
        this.rawClient.authorize().body();
    }

    public void authorize(RequestOptions requestOptions) {
        this.rawClient.authorize(requestOptions).body();
    }
}

