/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawLaborClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.labor.BreakTypesClient;
import com.squareup.square.labor.EmployeeWagesClient;
import com.squareup.square.labor.ShiftsClient;
import com.squareup.square.labor.TeamMemberWagesClient;
import com.squareup.square.labor.WorkweekConfigsClient;
import com.squareup.square.types.BulkPublishScheduledShiftsRequest;
import com.squareup.square.types.BulkPublishScheduledShiftsResponse;
import com.squareup.square.types.CreateScheduledShiftRequest;
import com.squareup.square.types.CreateScheduledShiftResponse;
import com.squareup.square.types.CreateTimecardRequest;
import com.squareup.square.types.CreateTimecardResponse;
import com.squareup.square.types.DeleteTimecardRequest;
import com.squareup.square.types.DeleteTimecardResponse;
import com.squareup.square.types.PublishScheduledShiftRequest;
import com.squareup.square.types.PublishScheduledShiftResponse;
import com.squareup.square.types.RetrieveScheduledShiftRequest;
import com.squareup.square.types.RetrieveScheduledShiftResponse;
import com.squareup.square.types.RetrieveTimecardRequest;
import com.squareup.square.types.RetrieveTimecardResponse;
import com.squareup.square.types.SearchScheduledShiftsRequest;
import com.squareup.square.types.SearchScheduledShiftsResponse;
import com.squareup.square.types.SearchTimecardsRequest;
import com.squareup.square.types.SearchTimecardsResponse;
import com.squareup.square.types.UpdateScheduledShiftRequest;
import com.squareup.square.types.UpdateScheduledShiftResponse;
import com.squareup.square.types.UpdateTimecardRequest;
import com.squareup.square.types.UpdateTimecardResponse;
import java.util.function.Supplier;

public class LaborClient {
    protected final ClientOptions clientOptions;
    private final RawLaborClient rawClient;
    protected final Supplier<BreakTypesClient> breakTypesClient;
    protected final Supplier<EmployeeWagesClient> employeeWagesClient;
    protected final Supplier<ShiftsClient> shiftsClient;
    protected final Supplier<TeamMemberWagesClient> teamMemberWagesClient;
    protected final Supplier<WorkweekConfigsClient> workweekConfigsClient;

    public LaborClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawLaborClient(clientOptions);
        this.breakTypesClient = Suppliers.memoize(() -> new BreakTypesClient(clientOptions));
        this.employeeWagesClient = Suppliers.memoize(() -> new EmployeeWagesClient(clientOptions));
        this.shiftsClient = Suppliers.memoize(() -> new ShiftsClient(clientOptions));
        this.teamMemberWagesClient = Suppliers.memoize(() -> new TeamMemberWagesClient(clientOptions));
        this.workweekConfigsClient = Suppliers.memoize(() -> new WorkweekConfigsClient(clientOptions));
    }

    public RawLaborClient withRawResponse() {
        return this.rawClient;
    }

    public CreateScheduledShiftResponse createScheduledShift(CreateScheduledShiftRequest request) {
        return this.rawClient.createScheduledShift(request).body();
    }

    public CreateScheduledShiftResponse createScheduledShift(CreateScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.createScheduledShift(request, requestOptions).body();
    }

    public BulkPublishScheduledShiftsResponse bulkPublishScheduledShifts(BulkPublishScheduledShiftsRequest request) {
        return this.rawClient.bulkPublishScheduledShifts(request).body();
    }

    public BulkPublishScheduledShiftsResponse bulkPublishScheduledShifts(BulkPublishScheduledShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkPublishScheduledShifts(request, requestOptions).body();
    }

    public SearchScheduledShiftsResponse searchScheduledShifts() {
        return this.rawClient.searchScheduledShifts().body();
    }

    public SearchScheduledShiftsResponse searchScheduledShifts(SearchScheduledShiftsRequest request) {
        return this.rawClient.searchScheduledShifts(request).body();
    }

    public SearchScheduledShiftsResponse searchScheduledShifts(SearchScheduledShiftsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchScheduledShifts(request, requestOptions).body();
    }

    public RetrieveScheduledShiftResponse retrieveScheduledShift(RetrieveScheduledShiftRequest request) {
        return this.rawClient.retrieveScheduledShift(request).body();
    }

    public RetrieveScheduledShiftResponse retrieveScheduledShift(RetrieveScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveScheduledShift(request, requestOptions).body();
    }

    public UpdateScheduledShiftResponse updateScheduledShift(UpdateScheduledShiftRequest request) {
        return this.rawClient.updateScheduledShift(request).body();
    }

    public UpdateScheduledShiftResponse updateScheduledShift(UpdateScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateScheduledShift(request, requestOptions).body();
    }

    public PublishScheduledShiftResponse publishScheduledShift(PublishScheduledShiftRequest request) {
        return this.rawClient.publishScheduledShift(request).body();
    }

    public PublishScheduledShiftResponse publishScheduledShift(PublishScheduledShiftRequest request, RequestOptions requestOptions) {
        return this.rawClient.publishScheduledShift(request, requestOptions).body();
    }

    public CreateTimecardResponse createTimecard(CreateTimecardRequest request) {
        return this.rawClient.createTimecard(request).body();
    }

    public CreateTimecardResponse createTimecard(CreateTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.createTimecard(request, requestOptions).body();
    }

    public SearchTimecardsResponse searchTimecards() {
        return this.rawClient.searchTimecards().body();
    }

    public SearchTimecardsResponse searchTimecards(SearchTimecardsRequest request) {
        return this.rawClient.searchTimecards(request).body();
    }

    public SearchTimecardsResponse searchTimecards(SearchTimecardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchTimecards(request, requestOptions).body();
    }

    public RetrieveTimecardResponse retrieveTimecard(RetrieveTimecardRequest request) {
        return this.rawClient.retrieveTimecard(request).body();
    }

    public RetrieveTimecardResponse retrieveTimecard(RetrieveTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveTimecard(request, requestOptions).body();
    }

    public UpdateTimecardResponse updateTimecard(UpdateTimecardRequest request) {
        return this.rawClient.updateTimecard(request).body();
    }

    public UpdateTimecardResponse updateTimecard(UpdateTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateTimecard(request, requestOptions).body();
    }

    public DeleteTimecardResponse deleteTimecard(DeleteTimecardRequest request) {
        return this.rawClient.deleteTimecard(request).body();
    }

    public DeleteTimecardResponse deleteTimecard(DeleteTimecardRequest request, RequestOptions requestOptions) {
        return this.rawClient.deleteTimecard(request, requestOptions).body();
    }

    public BreakTypesClient breakTypes() {
        return this.breakTypesClient.get();
    }

    public EmployeeWagesClient employeeWages() {
        return this.employeeWagesClient.get();
    }

    public ShiftsClient shifts() {
        return this.shiftsClient.get();
    }

    public TeamMemberWagesClient teamMemberWages() {
        return this.teamMemberWagesClient.get();
    }

    public WorkweekConfigsClient workweekConfigs() {
        return this.workweekConfigsClient.get();
    }
}

