/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawGiftCardsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.giftcards.ActivitiesClient;
import com.squareup.square.types.CreateGiftCardRequest;
import com.squareup.square.types.CreateGiftCardResponse;
import com.squareup.square.types.GetGiftCardFromGanRequest;
import com.squareup.square.types.GetGiftCardFromGanResponse;
import com.squareup.square.types.GetGiftCardFromNonceRequest;
import com.squareup.square.types.GetGiftCardFromNonceResponse;
import com.squareup.square.types.GetGiftCardResponse;
import com.squareup.square.types.GetGiftCardsRequest;
import com.squareup.square.types.GiftCard;
import com.squareup.square.types.LinkCustomerToGiftCardRequest;
import com.squareup.square.types.LinkCustomerToGiftCardResponse;
import com.squareup.square.types.ListGiftCardsRequest;
import com.squareup.square.types.UnlinkCustomerFromGiftCardRequest;
import com.squareup.square.types.UnlinkCustomerFromGiftCardResponse;
import java.util.function.Supplier;

public class GiftCardsClient {
    protected final ClientOptions clientOptions;
    private final RawGiftCardsClient rawClient;
    protected final Supplier<ActivitiesClient> activitiesClient;

    public GiftCardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawGiftCardsClient(clientOptions);
        this.activitiesClient = Suppliers.memoize(() -> new ActivitiesClient(clientOptions));
    }

    public RawGiftCardsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<GiftCard> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<GiftCard> list(ListGiftCardsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<GiftCard> list(ListGiftCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public CreateGiftCardResponse create(CreateGiftCardRequest request) {
        return this.rawClient.create(request).body();
    }

    public CreateGiftCardResponse create(CreateGiftCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).body();
    }

    public GetGiftCardFromGanResponse getFromGan(GetGiftCardFromGanRequest request) {
        return this.rawClient.getFromGan(request).body();
    }

    public GetGiftCardFromGanResponse getFromGan(GetGiftCardFromGanRequest request, RequestOptions requestOptions) {
        return this.rawClient.getFromGan(request, requestOptions).body();
    }

    public GetGiftCardFromNonceResponse getFromNonce(GetGiftCardFromNonceRequest request) {
        return this.rawClient.getFromNonce(request).body();
    }

    public GetGiftCardFromNonceResponse getFromNonce(GetGiftCardFromNonceRequest request, RequestOptions requestOptions) {
        return this.rawClient.getFromNonce(request, requestOptions).body();
    }

    public LinkCustomerToGiftCardResponse linkCustomer(LinkCustomerToGiftCardRequest request) {
        return this.rawClient.linkCustomer(request).body();
    }

    public LinkCustomerToGiftCardResponse linkCustomer(LinkCustomerToGiftCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.linkCustomer(request, requestOptions).body();
    }

    public UnlinkCustomerFromGiftCardResponse unlinkCustomer(UnlinkCustomerFromGiftCardRequest request) {
        return this.rawClient.unlinkCustomer(request).body();
    }

    public UnlinkCustomerFromGiftCardResponse unlinkCustomer(UnlinkCustomerFromGiftCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.unlinkCustomer(request, requestOptions).body();
    }

    public GetGiftCardResponse get(GetGiftCardsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetGiftCardResponse get(GetGiftCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public ActivitiesClient activities() {
        return this.activitiesClient.get();
    }
}

