/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawDisputesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.disputes.EvidenceClient;
import com.squareup.square.types.AcceptDisputeResponse;
import com.squareup.square.types.AcceptDisputesRequest;
import com.squareup.square.types.CreateDisputeEvidenceFileResponse;
import com.squareup.square.types.CreateDisputeEvidenceTextRequest;
import com.squareup.square.types.CreateDisputeEvidenceTextResponse;
import com.squareup.square.types.CreateEvidenceFileDisputesRequest;
import com.squareup.square.types.Dispute;
import com.squareup.square.types.GetDisputeResponse;
import com.squareup.square.types.GetDisputesRequest;
import com.squareup.square.types.ListDisputesRequest;
import com.squareup.square.types.SubmitEvidenceDisputesRequest;
import com.squareup.square.types.SubmitEvidenceResponse;
import java.util.function.Supplier;

public class DisputesClient {
    protected final ClientOptions clientOptions;
    private final RawDisputesClient rawClient;
    protected final Supplier<EvidenceClient> evidenceClient;

    public DisputesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawDisputesClient(clientOptions);
        this.evidenceClient = Suppliers.memoize(() -> new EvidenceClient(clientOptions));
    }

    public RawDisputesClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<Dispute> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<Dispute> list(ListDisputesRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<Dispute> list(ListDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public GetDisputeResponse get(GetDisputesRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetDisputeResponse get(GetDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }

    public AcceptDisputeResponse accept(AcceptDisputesRequest request) {
        return this.rawClient.accept(request).body();
    }

    public AcceptDisputeResponse accept(AcceptDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.accept(request, requestOptions).body();
    }

    public CreateDisputeEvidenceFileResponse createEvidenceFile(CreateEvidenceFileDisputesRequest request) {
        return this.rawClient.createEvidenceFile(request).body();
    }

    public CreateDisputeEvidenceFileResponse createEvidenceFile(CreateEvidenceFileDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.createEvidenceFile(request, requestOptions).body();
    }

    public CreateDisputeEvidenceTextResponse createEvidenceText(CreateDisputeEvidenceTextRequest request) {
        return this.rawClient.createEvidenceText(request).body();
    }

    public CreateDisputeEvidenceTextResponse createEvidenceText(CreateDisputeEvidenceTextRequest request, RequestOptions requestOptions) {
        return this.rawClient.createEvidenceText(request, requestOptions).body();
    }

    public SubmitEvidenceResponse submitEvidence(SubmitEvidenceDisputesRequest request) {
        return this.rawClient.submitEvidence(request).body();
    }

    public SubmitEvidenceResponse submitEvidence(SubmitEvidenceDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.submitEvidence(request, requestOptions).body();
    }

    public EvidenceClient evidence() {
        return this.evidenceClient.get();
    }
}

