/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawCatalogClient;
import com.squareup.square.catalog.ImagesClient;
import com.squareup.square.catalog.ObjectClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BatchDeleteCatalogObjectsRequest;
import com.squareup.square.types.BatchDeleteCatalogObjectsResponse;
import com.squareup.square.types.BatchGetCatalogObjectsRequest;
import com.squareup.square.types.BatchGetCatalogObjectsResponse;
import com.squareup.square.types.BatchUpsertCatalogObjectsRequest;
import com.squareup.square.types.BatchUpsertCatalogObjectsResponse;
import com.squareup.square.types.CatalogInfoResponse;
import com.squareup.square.types.CatalogObject;
import com.squareup.square.types.ListCatalogRequest;
import com.squareup.square.types.SearchCatalogItemsRequest;
import com.squareup.square.types.SearchCatalogItemsResponse;
import com.squareup.square.types.SearchCatalogObjectsRequest;
import com.squareup.square.types.SearchCatalogObjectsResponse;
import com.squareup.square.types.UpdateItemModifierListsRequest;
import com.squareup.square.types.UpdateItemModifierListsResponse;
import com.squareup.square.types.UpdateItemTaxesRequest;
import com.squareup.square.types.UpdateItemTaxesResponse;
import java.util.function.Supplier;

public class CatalogClient {
    protected final ClientOptions clientOptions;
    private final RawCatalogClient rawClient;
    protected final Supplier<ImagesClient> imagesClient;
    protected final Supplier<ObjectClient> objectClient;

    public CatalogClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawCatalogClient(clientOptions);
        this.imagesClient = Suppliers.memoize(() -> new ImagesClient(clientOptions));
        this.objectClient = Suppliers.memoize(() -> new ObjectClient(clientOptions));
    }

    public RawCatalogClient withRawResponse() {
        return this.rawClient;
    }

    public BatchDeleteCatalogObjectsResponse batchDelete(BatchDeleteCatalogObjectsRequest request) {
        return this.rawClient.batchDelete(request).body();
    }

    public BatchDeleteCatalogObjectsResponse batchDelete(BatchDeleteCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchDelete(request, requestOptions).body();
    }

    public BatchGetCatalogObjectsResponse batchGet(BatchGetCatalogObjectsRequest request) {
        return this.rawClient.batchGet(request).body();
    }

    public BatchGetCatalogObjectsResponse batchGet(BatchGetCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchGet(request, requestOptions).body();
    }

    public BatchUpsertCatalogObjectsResponse batchUpsert(BatchUpsertCatalogObjectsRequest request) {
        return this.rawClient.batchUpsert(request).body();
    }

    public BatchUpsertCatalogObjectsResponse batchUpsert(BatchUpsertCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.batchUpsert(request, requestOptions).body();
    }

    public CatalogInfoResponse info() {
        return this.rawClient.info().body();
    }

    public CatalogInfoResponse info(RequestOptions requestOptions) {
        return this.rawClient.info(requestOptions).body();
    }

    public SyncPagingIterable<CatalogObject> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<CatalogObject> list(ListCatalogRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<CatalogObject> list(ListCatalogRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public SearchCatalogObjectsResponse search() {
        return this.rawClient.search().body();
    }

    public SearchCatalogObjectsResponse search(SearchCatalogObjectsRequest request) {
        return this.rawClient.search(request).body();
    }

    public SearchCatalogObjectsResponse search(SearchCatalogObjectsRequest request, RequestOptions requestOptions) {
        return this.rawClient.search(request, requestOptions).body();
    }

    public SearchCatalogItemsResponse searchItems() {
        return this.rawClient.searchItems().body();
    }

    public SearchCatalogItemsResponse searchItems(SearchCatalogItemsRequest request) {
        return this.rawClient.searchItems(request).body();
    }

    public SearchCatalogItemsResponse searchItems(SearchCatalogItemsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchItems(request, requestOptions).body();
    }

    public UpdateItemModifierListsResponse updateItemModifierLists(UpdateItemModifierListsRequest request) {
        return this.rawClient.updateItemModifierLists(request).body();
    }

    public UpdateItemModifierListsResponse updateItemModifierLists(UpdateItemModifierListsRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateItemModifierLists(request, requestOptions).body();
    }

    public UpdateItemTaxesResponse updateItemTaxes(UpdateItemTaxesRequest request) {
        return this.rawClient.updateItemTaxes(request).body();
    }

    public UpdateItemTaxesResponse updateItemTaxes(UpdateItemTaxesRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateItemTaxes(request, requestOptions).body();
    }

    public ImagesClient images() {
        return this.imagesClient.get();
    }

    public ObjectClient object() {
        return this.objectClient.get();
    }
}

