/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.RawBankAccountsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BankAccount;
import com.squareup.square.types.GetBankAccountByV1IdResponse;
import com.squareup.square.types.GetBankAccountResponse;
import com.squareup.square.types.GetBankAccountsRequest;
import com.squareup.square.types.GetByV1IdBankAccountsRequest;
import com.squareup.square.types.ListBankAccountsRequest;

public class BankAccountsClient {
    protected final ClientOptions clientOptions;
    private final RawBankAccountsClient rawClient;

    public BankAccountsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawBankAccountsClient(clientOptions);
    }

    public RawBankAccountsClient withRawResponse() {
        return this.rawClient;
    }

    public SyncPagingIterable<BankAccount> list() {
        return this.rawClient.list().body();
    }

    public SyncPagingIterable<BankAccount> list(ListBankAccountsRequest request) {
        return this.rawClient.list(request).body();
    }

    public SyncPagingIterable<BankAccount> list(ListBankAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).body();
    }

    public GetBankAccountByV1IdResponse getByV1Id(GetByV1IdBankAccountsRequest request) {
        return this.rawClient.getByV1Id(request).body();
    }

    public GetBankAccountByV1IdResponse getByV1Id(GetByV1IdBankAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.getByV1Id(request, requestOptions).body();
    }

    public GetBankAccountResponse get(GetBankAccountsRequest request) {
        return this.rawClient.get(request).body();
    }

    public GetBankAccountResponse get(GetBankAccountsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).body();
    }
}

