/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawTeamClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.types.CreateJobRequest;
import com.squareup.square.types.CreateJobResponse;
import com.squareup.square.types.ListJobsRequest;
import com.squareup.square.types.ListJobsResponse;
import com.squareup.square.types.RetrieveJobRequest;
import com.squareup.square.types.RetrieveJobResponse;
import com.squareup.square.types.UpdateJobRequest;
import com.squareup.square.types.UpdateJobResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncTeamClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawTeamClient rawClient;

    public AsyncTeamClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawTeamClient(clientOptions);
    }

    public AsyncRawTeamClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<ListJobsResponse> listJobs() {
        return this.rawClient.listJobs().thenApply(response -> (ListJobsResponse)response.body());
    }

    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest request) {
        return this.rawClient.listJobs(request).thenApply(response -> (ListJobsResponse)response.body());
    }

    public CompletableFuture<ListJobsResponse> listJobs(ListJobsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listJobs(request, requestOptions).thenApply(response -> (ListJobsResponse)response.body());
    }

    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest request) {
        return this.rawClient.createJob(request).thenApply(response -> (CreateJobResponse)response.body());
    }

    public CompletableFuture<CreateJobResponse> createJob(CreateJobRequest request, RequestOptions requestOptions) {
        return this.rawClient.createJob(request, requestOptions).thenApply(response -> (CreateJobResponse)response.body());
    }

    public CompletableFuture<RetrieveJobResponse> retrieveJob(RetrieveJobRequest request) {
        return this.rawClient.retrieveJob(request).thenApply(response -> (RetrieveJobResponse)response.body());
    }

    public CompletableFuture<RetrieveJobResponse> retrieveJob(RetrieveJobRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveJob(request, requestOptions).thenApply(response -> (RetrieveJobResponse)response.body());
    }

    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest request) {
        return this.rawClient.updateJob(request).thenApply(response -> (UpdateJobResponse)response.body());
    }

    public CompletableFuture<UpdateJobResponse> updateJob(UpdateJobRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateJob(request, requestOptions).thenApply(response -> (UpdateJobResponse)response.body());
    }
}

