/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.BatchChangeInventoryRequest;
import com.squareup.square.types.BatchChangeInventoryResponse;
import com.squareup.square.types.BatchGetInventoryChangesResponse;
import com.squareup.square.types.BatchGetInventoryCountsRequest;
import com.squareup.square.types.BatchGetInventoryCountsResponse;
import com.squareup.square.types.BatchRetrieveInventoryChangesRequest;
import com.squareup.square.types.ChangesInventoryRequest;
import com.squareup.square.types.DeprecatedGetAdjustmentInventoryRequest;
import com.squareup.square.types.DeprecatedGetPhysicalCountInventoryRequest;
import com.squareup.square.types.GetAdjustmentInventoryRequest;
import com.squareup.square.types.GetInventoryAdjustmentResponse;
import com.squareup.square.types.GetInventoryChangesResponse;
import com.squareup.square.types.GetInventoryCountResponse;
import com.squareup.square.types.GetInventoryPhysicalCountResponse;
import com.squareup.square.types.GetInventoryRequest;
import com.squareup.square.types.GetInventoryTransferResponse;
import com.squareup.square.types.GetPhysicalCountInventoryRequest;
import com.squareup.square.types.GetTransferInventoryRequest;
import com.squareup.square.types.InventoryChange;
import com.squareup.square.types.InventoryCount;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawInventoryClient {
    protected final ClientOptions clientOptions;

    public AsyncRawInventoryClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>> deprecatedGetAdjustment(DeprecatedGetAdjustmentInventoryRequest request) {
        return this.deprecatedGetAdjustment(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>> deprecatedGetAdjustment(DeprecatedGetAdjustmentInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/adjustment").addPathSegment(request.getAdjustmentId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetInventoryAdjustmentResponse>((GetInventoryAdjustmentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryAdjustmentResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>> getAdjustment(GetAdjustmentInventoryRequest request) {
        return this.getAdjustment(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>> getAdjustment(GetAdjustmentInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/adjustments").addPathSegment(request.getAdjustmentId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetInventoryAdjustmentResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetInventoryAdjustmentResponse>((GetInventoryAdjustmentResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryAdjustmentResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>> deprecatedBatchChange(BatchChangeInventoryRequest request) {
        return this.deprecatedBatchChange(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>> deprecatedBatchChange(BatchChangeInventoryRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/batch-change").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>> future = new CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<BatchChangeInventoryResponse>((BatchChangeInventoryResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchChangeInventoryResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<BatchGetInventoryChangesResponse>> deprecatedBatchGetChanges() {
        return this.deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<BatchGetInventoryChangesResponse>> deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest request) {
        return this.deprecatedBatchGetChanges(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<BatchGetInventoryChangesResponse>> deprecatedBatchGetChanges(BatchRetrieveInventoryChangesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/batch-retrieve-changes").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<BatchGetInventoryChangesResponse>> future = new CompletableFuture<SquareClientHttpResponse<BatchGetInventoryChangesResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<BatchGetInventoryChangesResponse>((BatchGetInventoryChangesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryChangesResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<BatchGetInventoryCountsResponse>> deprecatedBatchGetCounts() {
        return this.deprecatedBatchGetCounts(BatchGetInventoryCountsRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<BatchGetInventoryCountsResponse>> deprecatedBatchGetCounts(BatchGetInventoryCountsRequest request) {
        return this.deprecatedBatchGetCounts(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<BatchGetInventoryCountsResponse>> deprecatedBatchGetCounts(BatchGetInventoryCountsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/batch-retrieve-counts").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<BatchGetInventoryCountsResponse>> future = new CompletableFuture<SquareClientHttpResponse<BatchGetInventoryCountsResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<BatchGetInventoryCountsResponse>((BatchGetInventoryCountsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryCountsResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>> batchCreateChanges(BatchChangeInventoryRequest request) {
        return this.batchCreateChanges(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>> batchCreateChanges(BatchChangeInventoryRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/changes/batch-create").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>> future = new CompletableFuture<SquareClientHttpResponse<BatchChangeInventoryResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<BatchChangeInventoryResponse>((BatchChangeInventoryResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchChangeInventoryResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> batchGetChanges() {
        return this.batchGetChanges(BatchRetrieveInventoryChangesRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> batchGetChanges(BatchRetrieveInventoryChangesRequest request) {
        return this.batchGetChanges(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> batchGetChanges(final BatchRetrieveInventoryChangesRequest request, final RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/changes/batch-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        BatchGetInventoryChangesResponse parsedResponse = (BatchGetInventoryChangesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryChangesResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        BatchRetrieveInventoryChangesRequest nextRequest = BatchRetrieveInventoryChangesRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getChanges().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawInventoryClient.this.batchGetChanges(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> batchGetCounts() {
        return this.batchGetCounts(BatchGetInventoryCountsRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> batchGetCounts(BatchGetInventoryCountsRequest request) {
        return this.batchGetCounts(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> batchGetCounts(final BatchGetInventoryCountsRequest request, final RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/counts/batch-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        BatchGetInventoryCountsResponse parsedResponse = (BatchGetInventoryCountsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BatchGetInventoryCountsResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        BatchGetInventoryCountsRequest nextRequest = BatchGetInventoryCountsRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getCounts().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawInventoryClient.this.batchGetCounts(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>> deprecatedGetPhysicalCount(DeprecatedGetPhysicalCountInventoryRequest request) {
        return this.deprecatedGetPhysicalCount(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>> deprecatedGetPhysicalCount(DeprecatedGetPhysicalCountInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/physical-count").addPathSegment(request.getPhysicalCountId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetInventoryPhysicalCountResponse>((GetInventoryPhysicalCountResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryPhysicalCountResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>> getPhysicalCount(GetPhysicalCountInventoryRequest request) {
        return this.getPhysicalCount(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>> getPhysicalCount(GetPhysicalCountInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/physical-counts").addPathSegment(request.getPhysicalCountId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetInventoryPhysicalCountResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetInventoryPhysicalCountResponse>((GetInventoryPhysicalCountResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryPhysicalCountResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryTransferResponse>> getTransfer(GetTransferInventoryRequest request) {
        return this.getTransfer(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetInventoryTransferResponse>> getTransfer(GetTransferInventoryRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory/transfers").addPathSegment(request.getTransferId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetInventoryTransferResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetInventoryTransferResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetInventoryTransferResponse>((GetInventoryTransferResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryTransferResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> get(GetInventoryRequest request) {
        return this.get(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> get(final GetInventoryRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory").addPathSegment(request.getCatalogObjectId());
        if (request.getLocationIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_ids", request.getLocationIds().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryCount>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        GetInventoryCountResponse parsedResponse = (GetInventoryCountResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryCountResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        GetInventoryRequest nextRequest = GetInventoryRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getCounts().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawInventoryClient.this.get(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> changes(ChangesInventoryRequest request) {
        return this.changes(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> changes(final ChangesInventoryRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/inventory").addPathSegment(request.getCatalogObjectId()).addPathSegments("changes");
        if (request.getLocationIds().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_ids", request.getLocationIds().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<InventoryChange>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        GetInventoryChangesResponse parsedResponse = (GetInventoryChangesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetInventoryChangesResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        ChangesInventoryRequest nextRequest = ChangesInventoryRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getChanges().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawInventoryClient.this.changes(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

