/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Card;
import com.squareup.square.types.CreateCardRequest;
import com.squareup.square.types.CreateCardResponse;
import com.squareup.square.types.DisableCardResponse;
import com.squareup.square.types.DisableCardsRequest;
import com.squareup.square.types.GetCardResponse;
import com.squareup.square.types.GetCardsRequest;
import com.squareup.square.types.ListCardsRequest;
import com.squareup.square.types.ListCardsResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawCardsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawCardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Card>>> list() {
        return this.list(ListCardsRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Card>>> list(ListCardsRequest request) {
        return this.list(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Card>>> list(final ListCardsRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cards");
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getCustomerId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "customer_id", request.getCustomerId().get(), false);
        }
        if (request.getIncludeDisabled().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "include_disabled", request.getIncludeDisabled().get(), false);
        }
        if (request.getReferenceId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "reference_id", request.getReferenceId().get(), false);
        }
        if (request.getSortOrder().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "sort_order", request.getSortOrder().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Card>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Card>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        ListCardsResponse parsedResponse = (ListCardsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListCardsResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        ListCardsRequest nextRequest = ListCardsRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getCards().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawCardsClient.this.list(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<CreateCardResponse>> create(CreateCardRequest request) {
        return this.create(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<CreateCardResponse>> create(CreateCardRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cards").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<CreateCardResponse>> future = new CompletableFuture<SquareClientHttpResponse<CreateCardResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<CreateCardResponse>((CreateCardResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateCardResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetCardResponse>> get(GetCardsRequest request) {
        return this.get(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetCardResponse>> get(GetCardsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cards").addPathSegment(request.getCardId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetCardResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetCardResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetCardResponse>((GetCardResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetCardResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<DisableCardResponse>> disable(DisableCardsRequest request) {
        return this.disable(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<DisableCardResponse>> disable(DisableCardsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/cards").addPathSegment(request.getCardId()).addPathSegments("disable").build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("POST", RequestBody.create((String)"", null)).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<DisableCardResponse>> future = new CompletableFuture<SquareClientHttpResponse<DisableCardResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<DisableCardResponse>((DisableCardResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), DisableCardResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

