/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.MediaTypes;
import com.squareup.square.core.ObjectMappers;
import com.squareup.square.core.QueryStringMapper;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SquareApiException;
import com.squareup.square.core.SquareClientHttpResponse;
import com.squareup.square.core.SquareException;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Booking;
import com.squareup.square.types.BulkRetrieveBookingsRequest;
import com.squareup.square.types.BulkRetrieveBookingsResponse;
import com.squareup.square.types.BulkRetrieveTeamMemberBookingProfilesRequest;
import com.squareup.square.types.BulkRetrieveTeamMemberBookingProfilesResponse;
import com.squareup.square.types.CancelBookingRequest;
import com.squareup.square.types.CancelBookingResponse;
import com.squareup.square.types.CreateBookingRequest;
import com.squareup.square.types.CreateBookingResponse;
import com.squareup.square.types.GetBookingResponse;
import com.squareup.square.types.GetBookingsRequest;
import com.squareup.square.types.GetBusinessBookingProfileResponse;
import com.squareup.square.types.ListBookingsRequest;
import com.squareup.square.types.ListBookingsResponse;
import com.squareup.square.types.RetrieveLocationBookingProfileRequest;
import com.squareup.square.types.RetrieveLocationBookingProfileResponse;
import com.squareup.square.types.SearchAvailabilityRequest;
import com.squareup.square.types.SearchAvailabilityResponse;
import com.squareup.square.types.UpdateBookingRequest;
import com.squareup.square.types.UpdateBookingResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class AsyncRawBookingsClient {
    protected final ClientOptions clientOptions;

    public AsyncRawBookingsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Booking>>> list() {
        return this.list(ListBookingsRequest.builder().build());
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Booking>>> list(ListBookingsRequest request) {
        return this.list(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Booking>>> list(final ListBookingsRequest request, final RequestOptions requestOptions) {
        HttpUrl.Builder httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings");
        if (request.getLimit().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "limit", request.getLimit().get(), false);
        }
        if (request.getCursor().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "cursor", request.getCursor().get(), false);
        }
        if (request.getCustomerId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "customer_id", request.getCustomerId().get(), false);
        }
        if (request.getTeamMemberId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "team_member_id", request.getTeamMemberId().get(), false);
        }
        if (request.getLocationId().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "location_id", request.getLocationId().get(), false);
        }
        if (request.getStartAtMin().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "start_at_min", request.getStartAtMin().get(), false);
        }
        if (request.getStartAtMax().isPresent()) {
            QueryStringMapper.addQueryParameter(httpUrl, "start_at_max", request.getStartAtMax().get(), false);
        }
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl.build()).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Booking>>> future = new CompletableFuture<SquareClientHttpResponse<SyncPagingIterable<Booking>>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        ListBookingsResponse parsedResponse = (ListBookingsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), ListBookingsResponse.class);
                        Optional<String> startingAfter = parsedResponse.getCursor();
                        ListBookingsRequest nextRequest = ListBookingsRequest.builder().from(request).cursor(startingAfter).build();
                        List result = parsedResponse.getBookings().orElse(Collections.emptyList());
                        future.complete(new SquareClientHttpResponse(new SyncPagingIterable(startingAfter.isPresent(), result, () -> {
                            try {
                                return AsyncRawBookingsClient.this.list(nextRequest, requestOptions).get().body();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                throw new RuntimeException(e);
                            }
                        }), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<CreateBookingResponse>> create(CreateBookingRequest request) {
        return this.create(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<CreateBookingResponse>> create(CreateBookingRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<CreateBookingResponse>> future = new CompletableFuture<SquareClientHttpResponse<CreateBookingResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<CreateBookingResponse>((CreateBookingResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CreateBookingResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<SearchAvailabilityResponse>> searchAvailability(SearchAvailabilityRequest request) {
        return this.searchAvailability(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<SearchAvailabilityResponse>> searchAvailability(SearchAvailabilityRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/availability/search").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<SearchAvailabilityResponse>> future = new CompletableFuture<SquareClientHttpResponse<SearchAvailabilityResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<SearchAvailabilityResponse>((SearchAvailabilityResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), SearchAvailabilityResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<BulkRetrieveBookingsResponse>> bulkRetrieveBookings(BulkRetrieveBookingsRequest request) {
        return this.bulkRetrieveBookings(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<BulkRetrieveBookingsResponse>> bulkRetrieveBookings(BulkRetrieveBookingsRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/bulk-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<BulkRetrieveBookingsResponse>> future = new CompletableFuture<SquareClientHttpResponse<BulkRetrieveBookingsResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<BulkRetrieveBookingsResponse>((BulkRetrieveBookingsResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkRetrieveBookingsResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetBusinessBookingProfileResponse>> getBusinessProfile() {
        return this.getBusinessProfile(null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetBusinessBookingProfileResponse>> getBusinessProfile(RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/business-booking-profile").build();
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetBusinessBookingProfileResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetBusinessBookingProfileResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetBusinessBookingProfileResponse>((GetBusinessBookingProfileResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetBusinessBookingProfileResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<RetrieveLocationBookingProfileResponse>> retrieveLocationBookingProfile(RetrieveLocationBookingProfileRequest request) {
        return this.retrieveLocationBookingProfile(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<RetrieveLocationBookingProfileResponse>> retrieveLocationBookingProfile(RetrieveLocationBookingProfileRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/location-booking-profiles").addPathSegment(request.getLocationId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<RetrieveLocationBookingProfileResponse>> future = new CompletableFuture<SquareClientHttpResponse<RetrieveLocationBookingProfileResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<RetrieveLocationBookingProfileResponse>((RetrieveLocationBookingProfileResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), RetrieveLocationBookingProfileResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<BulkRetrieveTeamMemberBookingProfilesResponse>> bulkRetrieveTeamMemberBookingProfiles(BulkRetrieveTeamMemberBookingProfilesRequest request) {
        return this.bulkRetrieveTeamMemberBookingProfiles(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<BulkRetrieveTeamMemberBookingProfilesResponse>> bulkRetrieveTeamMemberBookingProfiles(BulkRetrieveTeamMemberBookingProfilesRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings/team-member-booking-profiles/bulk-retrieve").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<BulkRetrieveTeamMemberBookingProfilesResponse>> future = new CompletableFuture<SquareClientHttpResponse<BulkRetrieveTeamMemberBookingProfilesResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<BulkRetrieveTeamMemberBookingProfilesResponse>((BulkRetrieveTeamMemberBookingProfilesResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), BulkRetrieveTeamMemberBookingProfilesResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<GetBookingResponse>> get(GetBookingsRequest request) {
        return this.get(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<GetBookingResponse>> get(GetBookingsRequest request, RequestOptions requestOptions) {
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings").addPathSegment(request.getBookingId()).build();
        Request.Builder _requestBuilder = new Request.Builder().url(httpUrl).method("GET", null).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Accept", "application/json");
        Request okhttpRequest = _requestBuilder.build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<GetBookingResponse>> future = new CompletableFuture<SquareClientHttpResponse<GetBookingResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<GetBookingResponse>((GetBookingResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), GetBookingResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<UpdateBookingResponse>> update(UpdateBookingRequest request) {
        return this.update(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<UpdateBookingResponse>> update(UpdateBookingRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings").addPathSegment(request.getBookingId()).build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("PUT", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<UpdateBookingResponse>> future = new CompletableFuture<SquareClientHttpResponse<UpdateBookingResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<UpdateBookingResponse>((UpdateBookingResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), UpdateBookingResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }

    public CompletableFuture<SquareClientHttpResponse<CancelBookingResponse>> cancel(CancelBookingRequest request) {
        return this.cancel(request, null);
    }

    public CompletableFuture<SquareClientHttpResponse<CancelBookingResponse>> cancel(CancelBookingRequest request, RequestOptions requestOptions) {
        RequestBody body;
        HttpUrl httpUrl = HttpUrl.parse((String)this.clientOptions.environment().getUrl()).newBuilder().addPathSegments("v2/bookings").addPathSegment(request.getBookingId()).addPathSegments("cancel").build();
        try {
            body = RequestBody.create((byte[])ObjectMappers.JSON_MAPPER.writeValueAsBytes((Object)request), (MediaType)MediaTypes.APPLICATION_JSON);
        }
        catch (JsonProcessingException e) {
            throw new SquareException("Failed to serialize request", (Exception)((Object)e));
        }
        Request okhttpRequest = new Request.Builder().url(httpUrl).method("POST", body).headers(Headers.of(this.clientOptions.headers(requestOptions))).addHeader("Content-Type", "application/json").addHeader("Accept", "application/json").build();
        OkHttpClient client = this.clientOptions.httpClient();
        if (requestOptions != null && requestOptions.getTimeout().isPresent()) {
            client = this.clientOptions.httpClientWithTimeout(requestOptions);
        }
        final CompletableFuture<SquareClientHttpResponse<CancelBookingResponse>> future = new CompletableFuture<SquareClientHttpResponse<CancelBookingResponse>>();
        client.newCall(okhttpRequest).enqueue(new Callback(){

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                try (ResponseBody responseBody = response.body();){
                    if (response.isSuccessful()) {
                        future.complete(new SquareClientHttpResponse<CancelBookingResponse>((CancelBookingResponse)ObjectMappers.JSON_MAPPER.readValue(responseBody.string(), CancelBookingResponse.class), response));
                        return;
                    }
                    String responseBodyString = responseBody != null ? responseBody.string() : "{}";
                    future.completeExceptionally(new SquareApiException("Error with status code " + response.code(), response.code(), ObjectMappers.JSON_MAPPER.readValue(responseBodyString, Object.class), response));
                    return;
                }
                catch (IOException e) {
                    future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
                    return;
                }
            }

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(new SquareException("Network error executing HTTP request", e));
            }
        });
        return future;
    }
}

