/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawPayoutsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.GetPayoutResponse;
import com.squareup.square.types.GetPayoutsRequest;
import com.squareup.square.types.ListEntriesPayoutsRequest;
import com.squareup.square.types.ListPayoutsRequest;
import com.squareup.square.types.Payout;
import com.squareup.square.types.PayoutEntry;
import java.util.concurrent.CompletableFuture;

public class AsyncPayoutsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawPayoutsClient rawClient;

    public AsyncPayoutsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPayoutsClient(clientOptions);
    }

    public AsyncRawPayoutsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Payout>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Payout>> list(ListPayoutsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Payout>> list(ListPayoutsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetPayoutResponse> get(GetPayoutsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetPayoutResponse)response.body());
    }

    public CompletableFuture<GetPayoutResponse> get(GetPayoutsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetPayoutResponse)response.body());
    }

    public CompletableFuture<SyncPagingIterable<PayoutEntry>> listEntries(ListEntriesPayoutsRequest request) {
        return this.rawClient.listEntries(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<PayoutEntry>> listEntries(ListEntriesPayoutsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEntries(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }
}

