/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawPaymentsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.CancelPaymentByIdempotencyKeyRequest;
import com.squareup.square.types.CancelPaymentByIdempotencyKeyResponse;
import com.squareup.square.types.CancelPaymentResponse;
import com.squareup.square.types.CancelPaymentsRequest;
import com.squareup.square.types.CompletePaymentRequest;
import com.squareup.square.types.CompletePaymentResponse;
import com.squareup.square.types.CreatePaymentRequest;
import com.squareup.square.types.CreatePaymentResponse;
import com.squareup.square.types.GetPaymentResponse;
import com.squareup.square.types.GetPaymentsRequest;
import com.squareup.square.types.ListPaymentsRequest;
import com.squareup.square.types.Payment;
import com.squareup.square.types.UpdatePaymentRequest;
import com.squareup.square.types.UpdatePaymentResponse;
import java.util.concurrent.CompletableFuture;

public class AsyncPaymentsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawPaymentsClient rawClient;

    public AsyncPaymentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawPaymentsClient(clientOptions);
    }

    public AsyncRawPaymentsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Payment>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Payment>> list(ListPaymentsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Payment>> list(ListPaymentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreatePaymentResponse> create(CreatePaymentRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreatePaymentResponse)response.body());
    }

    public CompletableFuture<CreatePaymentResponse> create(CreatePaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreatePaymentResponse)response.body());
    }

    public CompletableFuture<CancelPaymentByIdempotencyKeyResponse> cancelByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest request) {
        return this.rawClient.cancelByIdempotencyKey(request).thenApply(response -> (CancelPaymentByIdempotencyKeyResponse)response.body());
    }

    public CompletableFuture<CancelPaymentByIdempotencyKeyResponse> cancelByIdempotencyKey(CancelPaymentByIdempotencyKeyRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancelByIdempotencyKey(request, requestOptions).thenApply(response -> (CancelPaymentByIdempotencyKeyResponse)response.body());
    }

    public CompletableFuture<GetPaymentResponse> get(GetPaymentsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetPaymentResponse)response.body());
    }

    public CompletableFuture<GetPaymentResponse> get(GetPaymentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetPaymentResponse)response.body());
    }

    public CompletableFuture<UpdatePaymentResponse> update(UpdatePaymentRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdatePaymentResponse)response.body());
    }

    public CompletableFuture<UpdatePaymentResponse> update(UpdatePaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdatePaymentResponse)response.body());
    }

    public CompletableFuture<CancelPaymentResponse> cancel(CancelPaymentsRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelPaymentResponse)response.body());
    }

    public CompletableFuture<CancelPaymentResponse> cancel(CancelPaymentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelPaymentResponse)response.body());
    }

    public CompletableFuture<CompletePaymentResponse> complete(CompletePaymentRequest request) {
        return this.rawClient.complete(request).thenApply(response -> (CompletePaymentResponse)response.body());
    }

    public CompletableFuture<CompletePaymentResponse> complete(CompletePaymentRequest request, RequestOptions requestOptions) {
        return this.rawClient.complete(request, requestOptions).thenApply(response -> (CompletePaymentResponse)response.body());
    }
}

