/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawLoyaltyClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.loyalty.AsyncAccountsClient;
import com.squareup.square.loyalty.AsyncProgramsClient;
import com.squareup.square.loyalty.AsyncRewardsClient;
import com.squareup.square.types.SearchLoyaltyEventsRequest;
import com.squareup.square.types.SearchLoyaltyEventsResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncLoyaltyClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawLoyaltyClient rawClient;
    protected final Supplier<AsyncAccountsClient> accountsClient;
    protected final Supplier<AsyncProgramsClient> programsClient;
    protected final Supplier<AsyncRewardsClient> rewardsClient;

    public AsyncLoyaltyClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawLoyaltyClient(clientOptions);
        this.accountsClient = Suppliers.memoize(() -> new AsyncAccountsClient(clientOptions));
        this.programsClient = Suppliers.memoize(() -> new AsyncProgramsClient(clientOptions));
        this.rewardsClient = Suppliers.memoize(() -> new AsyncRewardsClient(clientOptions));
    }

    public AsyncRawLoyaltyClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SearchLoyaltyEventsResponse> searchEvents() {
        return this.rawClient.searchEvents().thenApply(response -> (SearchLoyaltyEventsResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyEventsResponse> searchEvents(SearchLoyaltyEventsRequest request) {
        return this.rawClient.searchEvents(request).thenApply(response -> (SearchLoyaltyEventsResponse)response.body());
    }

    public CompletableFuture<SearchLoyaltyEventsResponse> searchEvents(SearchLoyaltyEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchEvents(request, requestOptions).thenApply(response -> (SearchLoyaltyEventsResponse)response.body());
    }

    public AsyncAccountsClient accounts() {
        return this.accountsClient.get();
    }

    public AsyncProgramsClient programs() {
        return this.programsClient.get();
    }

    public AsyncRewardsClient rewards() {
        return this.rewardsClient.get();
    }
}

