/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawDisputesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.disputes.AsyncEvidenceClient;
import com.squareup.square.types.AcceptDisputeResponse;
import com.squareup.square.types.AcceptDisputesRequest;
import com.squareup.square.types.CreateDisputeEvidenceFileResponse;
import com.squareup.square.types.CreateDisputeEvidenceTextRequest;
import com.squareup.square.types.CreateDisputeEvidenceTextResponse;
import com.squareup.square.types.CreateEvidenceFileDisputesRequest;
import com.squareup.square.types.Dispute;
import com.squareup.square.types.GetDisputeResponse;
import com.squareup.square.types.GetDisputesRequest;
import com.squareup.square.types.ListDisputesRequest;
import com.squareup.square.types.SubmitEvidenceDisputesRequest;
import com.squareup.square.types.SubmitEvidenceResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncDisputesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDisputesClient rawClient;
    protected final Supplier<AsyncEvidenceClient> evidenceClient;

    public AsyncDisputesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDisputesClient(clientOptions);
        this.evidenceClient = Suppliers.memoize(() -> new AsyncEvidenceClient(clientOptions));
    }

    public AsyncRawDisputesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Dispute>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Dispute>> list(ListDisputesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Dispute>> list(ListDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetDisputeResponse> get(GetDisputesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetDisputeResponse)response.body());
    }

    public CompletableFuture<GetDisputeResponse> get(GetDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetDisputeResponse)response.body());
    }

    public CompletableFuture<AcceptDisputeResponse> accept(AcceptDisputesRequest request) {
        return this.rawClient.accept(request).thenApply(response -> (AcceptDisputeResponse)response.body());
    }

    public CompletableFuture<AcceptDisputeResponse> accept(AcceptDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.accept(request, requestOptions).thenApply(response -> (AcceptDisputeResponse)response.body());
    }

    public CompletableFuture<CreateDisputeEvidenceFileResponse> createEvidenceFile(CreateEvidenceFileDisputesRequest request) {
        return this.rawClient.createEvidenceFile(request).thenApply(response -> (CreateDisputeEvidenceFileResponse)response.body());
    }

    public CompletableFuture<CreateDisputeEvidenceFileResponse> createEvidenceFile(CreateEvidenceFileDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.createEvidenceFile(request, requestOptions).thenApply(response -> (CreateDisputeEvidenceFileResponse)response.body());
    }

    public CompletableFuture<CreateDisputeEvidenceTextResponse> createEvidenceText(CreateDisputeEvidenceTextRequest request) {
        return this.rawClient.createEvidenceText(request).thenApply(response -> (CreateDisputeEvidenceTextResponse)response.body());
    }

    public CompletableFuture<CreateDisputeEvidenceTextResponse> createEvidenceText(CreateDisputeEvidenceTextRequest request, RequestOptions requestOptions) {
        return this.rawClient.createEvidenceText(request, requestOptions).thenApply(response -> (CreateDisputeEvidenceTextResponse)response.body());
    }

    public CompletableFuture<SubmitEvidenceResponse> submitEvidence(SubmitEvidenceDisputesRequest request) {
        return this.rawClient.submitEvidence(request).thenApply(response -> (SubmitEvidenceResponse)response.body());
    }

    public CompletableFuture<SubmitEvidenceResponse> submitEvidence(SubmitEvidenceDisputesRequest request, RequestOptions requestOptions) {
        return this.rawClient.submitEvidence(request, requestOptions).thenApply(response -> (SubmitEvidenceResponse)response.body());
    }

    public AsyncEvidenceClient evidence() {
        return this.evidenceClient.get();
    }
}

