/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawDevicesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.devices.AsyncCodesClient;
import com.squareup.square.types.Device;
import com.squareup.square.types.GetDeviceResponse;
import com.squareup.square.types.GetDevicesRequest;
import com.squareup.square.types.ListDevicesRequest;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncDevicesClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawDevicesClient rawClient;
    protected final Supplier<AsyncCodesClient> codesClient;

    public AsyncDevicesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawDevicesClient(clientOptions);
        this.codesClient = Suppliers.memoize(() -> new AsyncCodesClient(clientOptions));
    }

    public AsyncRawDevicesClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Device>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Device>> list(ListDevicesRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Device>> list(ListDevicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<GetDeviceResponse> get(GetDevicesRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetDeviceResponse)response.body());
    }

    public CompletableFuture<GetDeviceResponse> get(GetDevicesRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetDeviceResponse)response.body());
    }

    public AsyncCodesClient codes() {
        return this.codesClient.get();
    }
}

