/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawCheckoutClient;
import com.squareup.square.checkout.AsyncPaymentLinksClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.types.RetrieveLocationSettingsRequest;
import com.squareup.square.types.RetrieveLocationSettingsResponse;
import com.squareup.square.types.RetrieveMerchantSettingsResponse;
import com.squareup.square.types.UpdateLocationSettingsRequest;
import com.squareup.square.types.UpdateLocationSettingsResponse;
import com.squareup.square.types.UpdateMerchantSettingsRequest;
import com.squareup.square.types.UpdateMerchantSettingsResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncCheckoutClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCheckoutClient rawClient;
    protected final Supplier<AsyncPaymentLinksClient> paymentLinksClient;

    public AsyncCheckoutClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCheckoutClient(clientOptions);
        this.paymentLinksClient = Suppliers.memoize(() -> new AsyncPaymentLinksClient(clientOptions));
    }

    public AsyncRawCheckoutClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<RetrieveLocationSettingsResponse> retrieveLocationSettings(RetrieveLocationSettingsRequest request) {
        return this.rawClient.retrieveLocationSettings(request).thenApply(response -> (RetrieveLocationSettingsResponse)response.body());
    }

    public CompletableFuture<RetrieveLocationSettingsResponse> retrieveLocationSettings(RetrieveLocationSettingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveLocationSettings(request, requestOptions).thenApply(response -> (RetrieveLocationSettingsResponse)response.body());
    }

    public CompletableFuture<UpdateLocationSettingsResponse> updateLocationSettings(UpdateLocationSettingsRequest request) {
        return this.rawClient.updateLocationSettings(request).thenApply(response -> (UpdateLocationSettingsResponse)response.body());
    }

    public CompletableFuture<UpdateLocationSettingsResponse> updateLocationSettings(UpdateLocationSettingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateLocationSettings(request, requestOptions).thenApply(response -> (UpdateLocationSettingsResponse)response.body());
    }

    public CompletableFuture<RetrieveMerchantSettingsResponse> retrieveMerchantSettings() {
        return this.rawClient.retrieveMerchantSettings().thenApply(response -> (RetrieveMerchantSettingsResponse)response.body());
    }

    public CompletableFuture<RetrieveMerchantSettingsResponse> retrieveMerchantSettings(RequestOptions requestOptions) {
        return this.rawClient.retrieveMerchantSettings(requestOptions).thenApply(response -> (RetrieveMerchantSettingsResponse)response.body());
    }

    public CompletableFuture<UpdateMerchantSettingsResponse> updateMerchantSettings(UpdateMerchantSettingsRequest request) {
        return this.rawClient.updateMerchantSettings(request).thenApply(response -> (UpdateMerchantSettingsResponse)response.body());
    }

    public CompletableFuture<UpdateMerchantSettingsResponse> updateMerchantSettings(UpdateMerchantSettingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.updateMerchantSettings(request, requestOptions).thenApply(response -> (UpdateMerchantSettingsResponse)response.body());
    }

    public AsyncPaymentLinksClient paymentLinks() {
        return this.paymentLinksClient.get();
    }
}

