/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawCardsClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Card;
import com.squareup.square.types.CreateCardRequest;
import com.squareup.square.types.CreateCardResponse;
import com.squareup.square.types.DisableCardResponse;
import com.squareup.square.types.DisableCardsRequest;
import com.squareup.square.types.GetCardResponse;
import com.squareup.square.types.GetCardsRequest;
import com.squareup.square.types.ListCardsRequest;
import java.util.concurrent.CompletableFuture;

public class AsyncCardsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawCardsClient rawClient;

    public AsyncCardsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawCardsClient(clientOptions);
    }

    public AsyncRawCardsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Card>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Card>> list(ListCardsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Card>> list(ListCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateCardResponse> create(CreateCardRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateCardResponse)response.body());
    }

    public CompletableFuture<CreateCardResponse> create(CreateCardRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateCardResponse)response.body());
    }

    public CompletableFuture<GetCardResponse> get(GetCardsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetCardResponse)response.body());
    }

    public CompletableFuture<GetCardResponse> get(GetCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetCardResponse)response.body());
    }

    public CompletableFuture<DisableCardResponse> disable(DisableCardsRequest request) {
        return this.rawClient.disable(request).thenApply(response -> (DisableCardResponse)response.body());
    }

    public CompletableFuture<DisableCardResponse> disable(DisableCardsRequest request, RequestOptions requestOptions) {
        return this.rawClient.disable(request, requestOptions).thenApply(response -> (DisableCardResponse)response.body());
    }
}

