/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.square;

import com.squareup.square.AsyncRawBookingsClient;
import com.squareup.square.bookings.AsyncCustomAttributeDefinitionsClient;
import com.squareup.square.bookings.AsyncCustomAttributesClient;
import com.squareup.square.bookings.AsyncLocationProfilesClient;
import com.squareup.square.bookings.AsyncTeamMemberProfilesClient;
import com.squareup.square.core.ClientOptions;
import com.squareup.square.core.RequestOptions;
import com.squareup.square.core.Suppliers;
import com.squareup.square.core.SyncPagingIterable;
import com.squareup.square.types.Booking;
import com.squareup.square.types.BulkRetrieveBookingsRequest;
import com.squareup.square.types.BulkRetrieveBookingsResponse;
import com.squareup.square.types.BulkRetrieveTeamMemberBookingProfilesRequest;
import com.squareup.square.types.BulkRetrieveTeamMemberBookingProfilesResponse;
import com.squareup.square.types.CancelBookingRequest;
import com.squareup.square.types.CancelBookingResponse;
import com.squareup.square.types.CreateBookingRequest;
import com.squareup.square.types.CreateBookingResponse;
import com.squareup.square.types.GetBookingResponse;
import com.squareup.square.types.GetBookingsRequest;
import com.squareup.square.types.GetBusinessBookingProfileResponse;
import com.squareup.square.types.ListBookingsRequest;
import com.squareup.square.types.RetrieveLocationBookingProfileRequest;
import com.squareup.square.types.RetrieveLocationBookingProfileResponse;
import com.squareup.square.types.SearchAvailabilityRequest;
import com.squareup.square.types.SearchAvailabilityResponse;
import com.squareup.square.types.UpdateBookingRequest;
import com.squareup.square.types.UpdateBookingResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class AsyncBookingsClient {
    protected final ClientOptions clientOptions;
    private final AsyncRawBookingsClient rawClient;
    protected final Supplier<AsyncCustomAttributeDefinitionsClient> customAttributeDefinitionsClient;
    protected final Supplier<AsyncCustomAttributesClient> customAttributesClient;
    protected final Supplier<AsyncLocationProfilesClient> locationProfilesClient;
    protected final Supplier<AsyncTeamMemberProfilesClient> teamMemberProfilesClient;

    public AsyncBookingsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawBookingsClient(clientOptions);
        this.customAttributeDefinitionsClient = Suppliers.memoize(() -> new AsyncCustomAttributeDefinitionsClient(clientOptions));
        this.customAttributesClient = Suppliers.memoize(() -> new AsyncCustomAttributesClient(clientOptions));
        this.locationProfilesClient = Suppliers.memoize(() -> new AsyncLocationProfilesClient(clientOptions));
        this.teamMemberProfilesClient = Suppliers.memoize(() -> new AsyncTeamMemberProfilesClient(clientOptions));
    }

    public AsyncRawBookingsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<SyncPagingIterable<Booking>> list() {
        return this.rawClient.list().thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Booking>> list(ListBookingsRequest request) {
        return this.rawClient.list(request).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<SyncPagingIterable<Booking>> list(ListBookingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.list(request, requestOptions).thenApply(response -> (SyncPagingIterable)response.body());
    }

    public CompletableFuture<CreateBookingResponse> create(CreateBookingRequest request) {
        return this.rawClient.create(request).thenApply(response -> (CreateBookingResponse)response.body());
    }

    public CompletableFuture<CreateBookingResponse> create(CreateBookingRequest request, RequestOptions requestOptions) {
        return this.rawClient.create(request, requestOptions).thenApply(response -> (CreateBookingResponse)response.body());
    }

    public CompletableFuture<SearchAvailabilityResponse> searchAvailability(SearchAvailabilityRequest request) {
        return this.rawClient.searchAvailability(request).thenApply(response -> (SearchAvailabilityResponse)response.body());
    }

    public CompletableFuture<SearchAvailabilityResponse> searchAvailability(SearchAvailabilityRequest request, RequestOptions requestOptions) {
        return this.rawClient.searchAvailability(request, requestOptions).thenApply(response -> (SearchAvailabilityResponse)response.body());
    }

    public CompletableFuture<BulkRetrieveBookingsResponse> bulkRetrieveBookings(BulkRetrieveBookingsRequest request) {
        return this.rawClient.bulkRetrieveBookings(request).thenApply(response -> (BulkRetrieveBookingsResponse)response.body());
    }

    public CompletableFuture<BulkRetrieveBookingsResponse> bulkRetrieveBookings(BulkRetrieveBookingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkRetrieveBookings(request, requestOptions).thenApply(response -> (BulkRetrieveBookingsResponse)response.body());
    }

    public CompletableFuture<GetBusinessBookingProfileResponse> getBusinessProfile() {
        return this.rawClient.getBusinessProfile().thenApply(response -> (GetBusinessBookingProfileResponse)response.body());
    }

    public CompletableFuture<GetBusinessBookingProfileResponse> getBusinessProfile(RequestOptions requestOptions) {
        return this.rawClient.getBusinessProfile(requestOptions).thenApply(response -> (GetBusinessBookingProfileResponse)response.body());
    }

    public CompletableFuture<RetrieveLocationBookingProfileResponse> retrieveLocationBookingProfile(RetrieveLocationBookingProfileRequest request) {
        return this.rawClient.retrieveLocationBookingProfile(request).thenApply(response -> (RetrieveLocationBookingProfileResponse)response.body());
    }

    public CompletableFuture<RetrieveLocationBookingProfileResponse> retrieveLocationBookingProfile(RetrieveLocationBookingProfileRequest request, RequestOptions requestOptions) {
        return this.rawClient.retrieveLocationBookingProfile(request, requestOptions).thenApply(response -> (RetrieveLocationBookingProfileResponse)response.body());
    }

    public CompletableFuture<BulkRetrieveTeamMemberBookingProfilesResponse> bulkRetrieveTeamMemberBookingProfiles(BulkRetrieveTeamMemberBookingProfilesRequest request) {
        return this.rawClient.bulkRetrieveTeamMemberBookingProfiles(request).thenApply(response -> (BulkRetrieveTeamMemberBookingProfilesResponse)response.body());
    }

    public CompletableFuture<BulkRetrieveTeamMemberBookingProfilesResponse> bulkRetrieveTeamMemberBookingProfiles(BulkRetrieveTeamMemberBookingProfilesRequest request, RequestOptions requestOptions) {
        return this.rawClient.bulkRetrieveTeamMemberBookingProfiles(request, requestOptions).thenApply(response -> (BulkRetrieveTeamMemberBookingProfilesResponse)response.body());
    }

    public CompletableFuture<GetBookingResponse> get(GetBookingsRequest request) {
        return this.rawClient.get(request).thenApply(response -> (GetBookingResponse)response.body());
    }

    public CompletableFuture<GetBookingResponse> get(GetBookingsRequest request, RequestOptions requestOptions) {
        return this.rawClient.get(request, requestOptions).thenApply(response -> (GetBookingResponse)response.body());
    }

    public CompletableFuture<UpdateBookingResponse> update(UpdateBookingRequest request) {
        return this.rawClient.update(request).thenApply(response -> (UpdateBookingResponse)response.body());
    }

    public CompletableFuture<UpdateBookingResponse> update(UpdateBookingRequest request, RequestOptions requestOptions) {
        return this.rawClient.update(request, requestOptions).thenApply(response -> (UpdateBookingResponse)response.body());
    }

    public CompletableFuture<CancelBookingResponse> cancel(CancelBookingRequest request) {
        return this.rawClient.cancel(request).thenApply(response -> (CancelBookingResponse)response.body());
    }

    public CompletableFuture<CancelBookingResponse> cancel(CancelBookingRequest request, RequestOptions requestOptions) {
        return this.rawClient.cancel(request, requestOptions).thenApply(response -> (CancelBookingResponse)response.body());
    }

    public AsyncCustomAttributeDefinitionsClient customAttributeDefinitions() {
        return this.customAttributeDefinitionsClient.get();
    }

    public AsyncCustomAttributesClient customAttributes() {
        return this.customAttributesClient.get();
    }

    public AsyncLocationProfilesClient locationProfiles() {
        return this.locationProfilesClient.get();
    }

    public AsyncTeamMemberProfilesClient teamMemberProfiles() {
        return this.teamMemberProfilesClient.get();
    }
}

