/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.jps.model.serialization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.openapi.util.text.Strings;
import sqldelight.com.intellij.util.PathUtilRt;
import sqldelight.com.intellij.util.SystemProperties;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class PathMacroUtil {
    @NonNls
    public static final String PROJECT_DIR_MACRO_NAME = "PROJECT_DIR";
    @NonNls
    public static final String PROJECT_NAME_MACRO_NAME = "PROJECT_NAME";
    @NonNls
    public static final String MODULE_DIR_MACRO_NAME = "MODULE_DIR";
    public static final String DEPRECATED_MODULE_DIR = "$MODULE_DIR$";
    public static final String MODULE_WORKING_DIR_NAME = "MODULE_WORKING_DIR";
    public static final String MODULE_WORKING_DIR = "$MODULE_WORKING_DIR$";
    @NonNls
    public static final String DIRECTORY_STORE_NAME = ".idea";
    @NonNls
    public static final String APPLICATION_HOME_DIR = "APPLICATION_HOME_DIR";
    @NonNls
    public static final String APPLICATION_CONFIG_DIR = "APPLICATION_CONFIG_DIR";
    @NonNls
    public static final String APPLICATION_PLUGINS_DIR = "APPLICATION_PLUGINS_DIR";
    @NonNls
    public static final String USER_HOME_NAME = "USER_HOME";
    private static volatile Map<String, String> ourGlobalMacrosForIde;
    private static volatile Map<String, String> ourGlobalMacrosForStandalone;

    @Nullable
    public static String getModuleDir(@NotNull String moduleFilePath) {
        String moduleDir;
        if (moduleFilePath == null) {
            PathMacroUtil.$$$reportNull$$$0(0);
        }
        if (Strings.isEmpty(moduleDir = PathUtilRt.getParentPath(moduleFilePath))) {
            return null;
        }
        String moduleDirParent = PathUtilRt.getParentPath(moduleDir);
        if (!Strings.isEmpty(moduleDirParent) && PathUtilRt.getFileName(moduleDir).equals(DIRECTORY_STORE_NAME)) {
            moduleDir = moduleDirParent;
        }
        if ((moduleDir = FileUtilRt.toSystemIndependentName(moduleDir)).endsWith(":/")) {
            moduleDir = moduleDir.substring(0, moduleDir.length() - 1);
        }
        return moduleDir;
    }

    @NotNull
    public static String getUserHomePath() {
        String string = Objects.requireNonNull(PathMacroUtil.getGlobalSystemMacroValue(USER_HOME_NAME));
        if (string == null) {
            PathMacroUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros() {
        return PathMacroUtil.getGlobalSystemMacros(true);
    }

    @NotNull
    public static Map<String, String> getGlobalSystemMacros(boolean insideIde) {
        if (insideIde) {
            if (ourGlobalMacrosForIde == null) {
                ourGlobalMacrosForIde = PathMacroUtil.computeGlobalPathMacrosInsideIde();
            }
            Map<String, String> map = ourGlobalMacrosForIde;
            if (map == null) {
                PathMacroUtil.$$$reportNull$$$0(2);
            }
            return map;
        }
        if (ourGlobalMacrosForStandalone == null) {
            ourGlobalMacrosForStandalone = PathMacroUtil.computeGlobalPathMacrosForStandaloneCode();
        }
        Map<String, String> map = ourGlobalMacrosForStandalone;
        if (map == null) {
            PathMacroUtil.$$$reportNull$$$0(3);
        }
        return map;
    }

    private static Map<String, String> computeGlobalPathMacrosForStandaloneCode() {
        HashMap<String, String> result = new HashMap<String, String>();
        String homePath = PathManager.getHomePath(false);
        if (homePath != null) {
            result.put(APPLICATION_HOME_DIR, FileUtilRt.toSystemIndependentName(homePath));
            result.put(APPLICATION_CONFIG_DIR, FileUtilRt.toSystemIndependentName(PathManager.getConfigPath()));
            result.put(APPLICATION_PLUGINS_DIR, FileUtilRt.toSystemIndependentName(PathManager.getPluginsPath()));
        }
        result.put(USER_HOME_NAME, PathMacroUtil.computeUserHomePath());
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> computeGlobalPathMacrosInsideIde() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(APPLICATION_HOME_DIR, FileUtilRt.toSystemIndependentName(PathManager.getHomePath()));
        result.put(APPLICATION_CONFIG_DIR, FileUtilRt.toSystemIndependentName(PathManager.getConfigPath()));
        result.put(APPLICATION_PLUGINS_DIR, FileUtilRt.toSystemIndependentName(PathManager.getPluginsPath()));
        result.put(USER_HOME_NAME, PathMacroUtil.computeUserHomePath());
        return Collections.unmodifiableMap(result);
    }

    @NotNull
    private static String computeUserHomePath() {
        String string = Strings.trimEnd(FileUtilRt.toSystemIndependentName(SystemProperties.getUserHome()), "/");
        if (string == null) {
            PathMacroUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name) {
        return PathMacroUtil.getGlobalSystemMacroValue(name, true);
    }

    @Nullable
    public static String getGlobalSystemMacroValue(String name, boolean insideIde) {
        return PathMacroUtil.getGlobalSystemMacros(insideIde).get(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/org/jetbrains/jps/model/serialization/PathMacroUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHomePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalSystemMacros";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUserHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

