/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jdom;

import sqldelight.org.jdom.Content;
import sqldelight.org.jdom.IllegalDataException;
import sqldelight.org.jdom.Parent;
import sqldelight.org.jdom.Verifier;
import sqldelight.org.jdom.output.XMLOutputter2;

public class Comment
extends Content {
    private static final long serialVersionUID = 200L;
    protected String text;

    protected Comment() {
        super(Content.CType.Comment);
    }

    public Comment(String text) {
        super(Content.CType.Comment);
        this.setText(text);
    }

    @Override
    public String getValue() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public Comment setText(String text) {
        String reason = Verifier.checkCommentData(text);
        if (reason != null) {
            throw new IllegalDataException(text, "comment", reason);
        }
        this.text = text;
        return this;
    }

    @Override
    public Comment clone() {
        return (Comment)super.clone();
    }

    @Override
    public Comment detach() {
        return (Comment)super.detach();
    }

    @Override
    protected Comment setParent(Parent parent) {
        return (Comment)super.setParent(parent);
    }

    public String toString() {
        return "[Comment: " + new XMLOutputter2().outputString(this) + "]";
    }
}

